/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.fx.handlers;

import com.google.common.reflect.TypeToken;
import java.util.Collections;
import java.util.List;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.gef.mvc.fx.handlers.AbstractHandler;
import org.eclipse.gef.mvc.fx.handlers.IOnClickHandler;
import org.eclipse.gef.mvc.fx.models.FocusModel;
import org.eclipse.gef.mvc.fx.models.SelectionModel;
import org.eclipse.gef.mvc.fx.operations.ChangeFocusOperation;
import org.eclipse.gef.mvc.fx.operations.ChangeSelectionOperation;
import org.eclipse.gef.mvc.fx.operations.DeselectOperation;
import org.eclipse.gef.mvc.fx.operations.ITransactionalOperation;
import org.eclipse.gef.mvc.fx.operations.SelectOperation;
import org.eclipse.gef.mvc.fx.parts.IContentPart;
import org.eclipse.gef.mvc.fx.parts.IRootPart;
import org.eclipse.gef.mvc.fx.parts.IVisualPart;
import org.eclipse.gef.mvc.fx.viewer.IViewer;

public class FocusAndSelectOnClickHandler
extends AbstractHandler
implements IOnClickHandler {
    @Override
    public void click(MouseEvent e) {
        if (!this.isFocusAndSelect(e)) {
            return;
        }
        IVisualPart<? extends Node> host = this.getHost();
        IViewer viewer = host.getRoot().getViewer();
        SelectionModel selectionModel = (SelectionModel)((Object)viewer.getAdapter(SelectionModel.class));
        boolean append = this.isAppend(e);
        if (host instanceof IContentPart) {
            IContentPart contentPart = (IContentPart)host;
            if (this.isRegistered(e.getTarget()) && !this.isRegisteredForHost(e.getTarget())) {
                return;
            }
            List<IContentPart> singletonHostList = Collections.singletonList(contentPart);
            boolean wasDeselected = false;
            AbstractOperation selectionChangeOperation = null;
            if (selectionModel.isSelected(contentPart)) {
                if (append) {
                    selectionChangeOperation = new DeselectOperation(viewer, singletonHostList);
                    wasDeselected = true;
                }
            } else if (contentPart.isSelectable()) {
                selectionChangeOperation = append ? new SelectOperation(viewer, singletonHostList) : new ChangeSelectionOperation(viewer, singletonHostList);
            }
            if (selectionChangeOperation != null) {
                try {
                    viewer.getDomain().execute((ITransactionalOperation)selectionChangeOperation, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (ExecutionException e1) {
                    throw new IllegalStateException(e1);
                }
            }
            ChangeFocusOperation changeFocusOperation = null;
            ObservableList<IContentPart<? extends Node>> selection = selectionModel.getSelectionUnmodifiable();
            if (wasDeselected && selection.isEmpty()) {
                changeFocusOperation = new ChangeFocusOperation(viewer, null);
            } else {
                IContentPart primarySelection = (IContentPart)selection.get(0);
                if (primarySelection.isFocusable()) {
                    FocusModel focusModel = (FocusModel)((Object)viewer.getAdapter((TypeToken)new TypeToken<FocusModel>(){}));
                    if (focusModel.getFocus() == primarySelection) {
                        primarySelection.getVisual().requestFocus();
                    } else {
                        changeFocusOperation = new ChangeFocusOperation(viewer, primarySelection);
                    }
                }
            }
            if (changeFocusOperation != null) {
                try {
                    viewer.getDomain().execute(changeFocusOperation, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (ExecutionException e1) {
                    throw new IllegalStateException(e1);
                }
            }
        } else if (host instanceof IRootPart && (!this.isRegistered(e.getTarget()) || this.isRegisteredForHost(e.getTarget()))) {
            if (append) {
                return;
            }
            try {
                FocusModel focusModel = (FocusModel)((Object)viewer.getAdapter((TypeToken)new TypeToken<FocusModel>(){}));
                if (focusModel.getFocus() == null) {
                    viewer.getRootPart().getVisual().requestFocus();
                } else {
                    viewer.getDomain().execute(new ChangeFocusOperation(viewer, null), (IProgressMonitor)new NullProgressMonitor());
                }
                viewer.getDomain().execute(new DeselectOperation(viewer, (List<? extends IContentPart<? extends Node>>)selectionModel.getSelectionUnmodifiable()), (IProgressMonitor)new NullProgressMonitor());
            }
            catch (ExecutionException e1) {
                throw new IllegalStateException(e1);
            }
        }
    }

    protected boolean isAppend(MouseEvent e) {
        return e.isShortcutDown();
    }

    protected boolean isFocusAndSelect(MouseEvent event) {
        return event.getClickCount() <= 1;
    }
}

