/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.expressions.operations;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.expressions.TupleLiteralExp;
import org.eclipse.ocl.expressions.TupleLiteralPart;
import org.eclipse.ocl.expressions.operations.OCLExpressionOperations;
import org.eclipse.ocl.internal.l10n.OCLMessages;
import org.eclipse.ocl.types.TupleType;
import org.eclipse.ocl.util.OCLUtil;
import org.eclipse.ocl.utilities.UMLReflection;

public class TupleLiteralExpOperations
extends OCLExpressionOperations {
    protected TupleLiteralExpOperations() {
    }

    public static <C, P> boolean checkTupleType(TupleLiteralExp<C, P> tupleLiteralExp, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = true;
        String message = null;
        Environment env = OCLUtil.getValidationEnvironment(tupleLiteralExp, context);
        if (env != null) {
            UMLReflection uml = env.getUMLReflection();
            Object type = tupleLiteralExp.getType();
            if (!(type instanceof TupleType)) {
                result = false;
                message = OCLMessages.bind(OCLMessages.TypeConformanceTupleLiteralExp_ERROR_, tupleLiteralExp.toString());
            } else {
                EList<TupleLiteralPart<C, P>> tp = tupleLiteralExp.getPart();
                List attributes = uml.getAttributes(type);
                if (tp.size() != attributes.size()) {
                    result = false;
                    message = OCLMessages.bind(OCLMessages.TypeConformanceTupleLiteralExpParts_ERROR_, tupleLiteralExp.toString());
                } else {
                    for (TupleLiteralPart part : tp) {
                        if (part.getAttribute() != null && uml.getOwningClassifier(part.getAttribute()) == type) continue;
                        result = false;
                        message = OCLMessages.bind(OCLMessages.TupleLiteralExpressionPart_ERROR_, part.getName(), tupleLiteralExp.toString());
                        break;
                    }
                }
            }
        }
        if (!result && diagnostics != null) {
            diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.ocl.expressions", 36, message, new Object[]{tupleLiteralExp}));
        }
        return result;
    }

    public static <C, P> boolean checkPartsUnique(TupleLiteralExp<C, P> tupleLiteralExp, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = true;
        String message = null;
        HashSet<String> names = new HashSet<String>();
        for (TupleLiteralPart part : tupleLiteralExp.getPart()) {
            String name = part.getName();
            if (names.add(name)) continue;
            result = false;
            message = OCLMessages.bind(OCLMessages.TupleDuplicateName_ERROR_, name, tupleLiteralExp.toString());
        }
        if (!result && diagnostics != null) {
            diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.ocl.expressions", 37, message, new Object[]{tupleLiteralExp}));
        }
        return result;
    }
}

