/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.codegen.jet;

import java.io.File;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.codegen.jet.JETCompileTemplateOperation;
import org.eclipse.emf.codegen.jet.JETNature;
import org.eclipse.emf.common.util.URI;

public class JETBuilder
extends IncrementalProjectBuilder {
    private static final String WORKING_LOCATION = "org.eclipse.emf.codegen.jet";

    protected IProject[] build(int kind, Map arguments, IProgressMonitor monitor) throws CoreException {
        IProject project = this.getProject();
        JETNature jetNature = JETNature.getRuntime(project);
        if (!project.exists() || jetNature == null) {
            return new IProject[0];
        }
        try {
            if (kind == 6) {
                this.fullBuild(monitor);
            } else {
                IResourceDelta delta = this.getDelta(project);
                if (delta == null) {
                    this.fullBuild(monitor);
                } else {
                    this.incrementalBuild(delta, monitor);
                }
            }
        }
        catch (OperationCanceledException delta) {
            // empty catch block
        }
        Set<IProject> interestingProjects = JETBuilder.getInterestingProjects(jetNature);
        return interestingProjects.toArray(new IProject[interestingProjects.size()]);
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
        File buildStateLocation = this.getBuildStateLocation();
        JETCompileTemplateOperation.State oldState = new JETCompileTemplateOperation.State(buildStateLocation);
        this.reconcile(oldState, new JETCompileTemplateOperation.State(), monitor);
    }

    private void reconcile(JETCompileTemplateOperation.State oldState, JETCompileTemplateOperation.State newState, IProgressMonitor monitor) throws CoreException {
        Map<URI, List<URI>> oldJavaFileToTemplateURIs = oldState.getJavaFileToTemplateURIs();
        Set<URI> javaFileURIs = oldJavaFileToTemplateURIs.keySet();
        javaFileURIs.removeAll(newState.getJavaFileToTemplateURIs().keySet());
        IWorkspaceRoot workspaceRoot = (IWorkspaceRoot)this.getProject().getParent();
        for (URI javaURI : javaFileURIs) {
            IResource javaResource = workspaceRoot.findMember((IPath)new Path(javaURI.toPlatformString(true)));
            if (javaResource == null || !javaResource.exists() || javaResource.getType() != 1) continue;
            javaResource.delete(true, monitor);
        }
    }

    protected void fullBuild(IProgressMonitor monitor) throws CoreException {
        JETNature nature = JETNature.getRuntime(this.getProject());
        if (nature != null) {
            JETCompileTemplateOperation compileTemplateOperation = new JETCompileTemplateOperation(this.getProject(), nature.getTemplateContainers());
            compileTemplateOperation.setInBuild(true);
            if (compileTemplateOperation.shouldCompile()) {
                File buildStateLocation = this.getBuildStateLocation();
                JETCompileTemplateOperation.State oldState = new JETCompileTemplateOperation.State(buildStateLocation);
                compileTemplateOperation.run(monitor);
                JETCompileTemplateOperation.State newState = compileTemplateOperation.getNewState();
                newState.saveState(buildStateLocation);
                this.reconcile(oldState, newState, monitor);
            }
        }
    }

    protected void incrementalBuild(IResourceDelta delta, IProgressMonitor monitor) throws CoreException {
        IProject project = this.getProject();
        JETNature nature = JETNature.getRuntime(project);
        if (nature != null && (delta.getKind() == 1 || delta.getKind() == 4 || delta.getKind() == 256 || delta.getKind() == 16384)) {
            final Set<IResource> containers = JETBuilder.getInterestingResourceContainers(nature);
            final AtomicBoolean found = new AtomicBoolean();
            delta.accept(new IResourceDeltaVisitor(){

                public boolean visit(IResourceDelta delta) throws CoreException {
                    if (containers.contains(delta.getResource())) {
                        found.set(true);
                    }
                    return !found.get();
                }
            }, false);
            if (found.get()) {
                JETCompileTemplateOperation compileTemplateOperation = new JETCompileTemplateOperation(project, nature.getTemplateContainers());
                compileTemplateOperation.setInBuild(true);
                if (compileTemplateOperation.shouldCompile()) {
                    File buildStateLocation = this.getBuildStateLocation();
                    JETCompileTemplateOperation.State oldState = new JETCompileTemplateOperation.State(buildStateLocation);
                    compileTemplateOperation.run(monitor);
                    JETCompileTemplateOperation.State newState = compileTemplateOperation.getNewState();
                    newState.saveState(buildStateLocation);
                    this.reconcile(oldState, newState, monitor);
                }
            }
        }
    }

    private static Set<IProject> getInterestingProjects(JETNature jetNature) {
        LinkedHashSet<IProject> projects = new LinkedHashSet<IProject>();
        for (IResource resource : JETBuilder.getInterestingResourceContainers(jetNature)) {
            projects.add(resource.getProject());
        }
        return projects;
    }

    private static Set<IResource> getInterestingResourceContainers(JETNature jetNature) {
        List<Object> templateContainers = jetNature.getTemplateContainers();
        LinkedHashSet<IResource> containers = new LinkedHashSet<IResource>();
        IWorkspaceRoot workspaceRoot = jetNature.getProject().getWorkspace().getRoot();
        for (Object object : templateContainers) {
            IResource resource;
            URI uri;
            if (object instanceof IResource) {
                containers.add((IResource)object);
                continue;
            }
            if (!(object instanceof URI) || !(uri = (URI)object).isPlatformResource() || (resource = workspaceRoot.findMember((IPath)new Path(uri.toPlatformString(true)))) == null) continue;
            containers.add(resource);
        }
        IContainer javaSourceContainer = jetNature.getJavaSourceContainer();
        if (javaSourceContainer != null) {
            containers.add((IResource)javaSourceContainer);
        }
        return containers;
    }

    private File getBuildStateLocation() {
        return new File(this.getWorkingLocation(), "build-state.xml");
    }

    private File getWorkingLocation() {
        IPath workingLocation = this.getProject().getWorkingLocation(WORKING_LOCATION);
        File file = workingLocation.toFile();
        return file;
    }

    static JETCompileTemplateOperation.State getBuildState(IProject project) {
        IPath workingLocation = project.getWorkingLocation(WORKING_LOCATION);
        return new JETCompileTemplateOperation.State(new File(workingLocation.toFile(), "build-state.xml"));
    }
}

