/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.net4j.protocol;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.internal.net4j.protocol.CDOClientProtocol;
import org.eclipse.emf.cdo.internal.net4j.protocol.CDOClientRequest;

public class RemoteTopicRequest
extends CDOClientRequest<Set<Integer>> {
    private String id;
    private boolean subscribe;

    public RemoteTopicRequest(CDOClientProtocol protocol, String id, boolean subscribe) {
        super(protocol, (short)69);
        this.id = id;
        this.subscribe = subscribe;
    }

    @Override
    protected void requesting(CDODataOutput out) throws IOException {
        out.writeString(this.id);
        out.writeBoolean(this.subscribe);
    }

    @Override
    protected Set<Integer> confirming(CDODataInput in) throws IOException {
        if (this.subscribe) {
            int sessionID;
            HashSet<Integer> result = new HashSet<Integer>();
            while ((sessionID = in.readXInt()) != -1) {
                result.add(sessionID);
            }
            return result;
        }
        in.readBoolean();
        return null;
    }

    protected String getAdditionalInfo() {
        return MessageFormat.format("id={0}, subscribe={1}", this.id, this.subscribe);
    }
}

