/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.dot.internal.ui.language.outline;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.dot.internal.language.htmllabel.HtmlContent;
import org.eclipse.gef.dot.internal.language.htmllabel.HtmlLabel;
import org.eclipse.swt.graphics.Image;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.outline.IOutlineNode;
import org.eclipse.xtext.ui.editor.outline.impl.DefaultOutlineTreeProvider;
import org.eclipse.xtext.ui.editor.outline.impl.DocumentRootNode;
import org.eclipse.xtext.ui.editor.outline.impl.EObjectNode;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.TextRegion;

public class DotHtmlLabelOutlineTreeProvider
extends DefaultOutlineTreeProvider {
    private IXtextDocument xtextDocument;
    private int offset = 0;

    void setOffset(int offset) {
        this.offset = offset;
    }

    void setXtextDocument(IXtextDocument xtextDocument) {
        this.xtextDocument = xtextDocument;
    }

    protected void _createChildren(DocumentRootNode parentNode, EObject modelElement) {
        if (modelElement instanceof HtmlLabel) {
            HtmlLabel htmlLabel = (HtmlLabel)modelElement;
            for (HtmlContent htmlContent : htmlLabel.getParts()) {
                if (htmlContent.getText() != null && !htmlContent.getText().trim().isEmpty()) {
                    this.createNode((IOutlineNode)parentNode, (EObject)htmlContent);
                    continue;
                }
                if (htmlContent.getTag() == null) continue;
                this.createNode((IOutlineNode)parentNode, (EObject)htmlContent.getTag());
            }
        } else {
            super._createChildren(parentNode, modelElement);
        }
    }

    protected void _createNode(IOutlineNode parentNode, EObject modelElement) {
        if (modelElement instanceof HtmlContent) {
            HtmlContent htmlContent = (HtmlContent)modelElement;
            if (htmlContent.getText() != null && !htmlContent.getText().trim().isEmpty()) {
                super._createNode(parentNode, (EObject)htmlContent);
            } else if (htmlContent.getTag() != null) {
                super._createNode(parentNode, (EObject)htmlContent.getTag());
            }
        } else {
            super._createNode(parentNode, modelElement);
        }
    }

    protected EObjectNode createEObjectNode(IOutlineNode parentNode, EObject modelElement, Image image, Object text, boolean isLeaf) {
        EObjectNode eObjectNode = new EObjectNode(modelElement, parentNode, image, text, isLeaf){

            public IXtextDocument getDocument() {
                return DotHtmlLabelOutlineTreeProvider.this.xtextDocument != null ? DotHtmlLabelOutlineTreeProvider.this.xtextDocument : super.getDocument();
            }
        };
        ICompositeNode parserNode = NodeModelUtils.getNode((EObject)modelElement);
        if (parserNode != null) {
            ITextRegion parserNodeTextRegion = parserNode.getTextRegion();
            TextRegion newTextRegion = new TextRegion(parserNodeTextRegion.getOffset() + this.offset, parserNodeTextRegion.getLength());
            eObjectNode.setTextRegion((ITextRegion)newTextRegion);
        }
        ITextRegion significantTextRegion = this.locationInFileProvider.getSignificantTextRegion(modelElement);
        TextRegion shortTextRegion = new TextRegion(significantTextRegion.getOffset() + this.offset, significantTextRegion.getLength());
        eObjectNode.setShortTextRegion((ITextRegion)shortTextRegion);
        return eObjectNode;
    }
}

