/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.editparts;

import java.util.Collections;
import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.ExposeHelper;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editparts.ViewportExposeHelper;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IResizableCompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ListItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.ResizableCompartmentEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.figures.ResizableCompartmentFigure;
import org.eclipse.gmf.runtime.diagram.ui.internal.figures.NestedResizableCompartmentFigure;
import org.eclipse.gmf.runtime.diagram.ui.internal.properties.Properties;
import org.eclipse.gmf.runtime.draw2d.ui.figures.ConstrainedToolbarLayout;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrapLabel;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.IMapMode;
import org.eclipse.gmf.runtime.notation.DrawerStyle;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.Ratio;
import org.eclipse.gmf.runtime.notation.Style;
import org.eclipse.gmf.runtime.notation.View;

public class NestableListItemEditPart
extends ListItemEditPart
implements IResizableCompartmentEditPart {
    static final int IS_RESIZABLE_FLAG = 64;
    WrapLabel textLabel = null;

    public NestableListItemEditPart(EObject view) {
        super(view);
        Node node;
        Style style;
        this.setFlag(64, false);
        Object model = this.basicGetModel();
        if (model instanceof Node && (style = (node = (Node)model).getStyle(NotationPackage.Literals.DRAWER_STYLE)) != null) {
            this.setFlag(64, true);
        }
    }

    @Override
    public WrapLabel getLabel() {
        if (this.isResizable()) {
            if (this.textLabel == null) {
                this.textLabel = this.createWrapLabel();
            }
            return this.textLabel;
        }
        return super.getLabel();
    }

    protected IFigure getMainLabel() {
        return this.getLabel();
    }

    @Override
    public String getCompartmentName() {
        return this.getLabelDelegate().getText();
    }

    @Override
    protected IFigure createFigure() {
        if (this.isResizable()) {
            IMapMode mm = this.getMapMode();
            NestedResizableCompartmentFigure compartmentFigure = new NestedResizableCompartmentFigure(mm);
            ConstrainedToolbarLayout layout = new ConstrainedToolbarLayout();
            layout.setStretchMajorAxis(false);
            layout.setStretchMinorAxis(false);
            layout.setMinorAlignment(1);
            compartmentFigure.getContentPane().setLayoutManager((LayoutManager)layout);
            compartmentFigure.getTextPane().add(this.getMainLabel());
            int one = mm.DPtoLP(1);
            int half_15 = mm.DPtoLP(15) / 2;
            compartmentFigure.getTextPane().setBorder((Border)new MarginBorder(one, half_15, one, half_15));
            compartmentFigure.getContentPane().setBorder((Border)new MarginBorder(one, mm.DPtoLP(15), one, half_15));
            this.getMainLabel().setVisible(true);
            return compartmentFigure;
        }
        return super.createFigure();
    }

    @Override
    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        if (this.isResizable()) {
            this.installEditPolicy("PrimaryDrag Policy", (EditPolicy)new ResizableCompartmentEditPolicy());
        }
    }

    protected final boolean isResizable() {
        return this.getFlag(64);
    }

    @Override
    protected List getModelChildren() {
        if (this.getModel() instanceof View) {
            return ((View)this.getModel()).getChildren();
        }
        return Collections.emptyList();
    }

    @Override
    public Object getAdapter(Class key) {
        if (key == ExposeHelper.class) {
            ViewportExposeHelper helper = new ViewportExposeHelper((GraphicalEditPart)this);
            return helper;
        }
        return super.getAdapter(key);
    }

    @Override
    protected void refreshVisuals() {
        super.refreshVisuals();
        if (this.isResizable()) {
            this.refreshCollapsed();
            this.refreshRatio();
        }
    }

    private ResizableCompartmentFigure getCompartmentFigure() {
        if (this.isResizable()) {
            return (ResizableCompartmentFigure)this.getFigure();
        }
        return null;
    }

    public IFigure getContentPane() {
        ResizableCompartmentFigure compartmentFigure = this.getCompartmentFigure();
        if (compartmentFigure != null) {
            return compartmentFigure.getContentPane();
        }
        return super.getContentPane();
    }

    @Override
    protected void handleNotificationEvent(Notification evt) {
        Object feature = evt.getFeature();
        if (NotationPackage.Literals.RATIO__VALUE.equals(feature) || evt.getOldValue() instanceof Ratio || evt.getNewValue() instanceof Ratio) {
            this.refreshRatio();
        } else if (NotationPackage.Literals.DRAWER_STYLE__COLLAPSED.equals(feature)) {
            this.setCollapsed((Boolean)evt.getNewValue(), true);
            this.getFigure().revalidate();
        } else {
            super.handleNotificationEvent(evt);
        }
    }

    protected void refreshRatio() {
        if (ViewUtil.isPropertySupported((View)((View)this.getModel()), (Object)Properties.ID_RATIO)) {
            this.setRatio((Double)ViewUtil.getStructuralFeatureValue((View)((View)this.getModel()), (EStructuralFeature)NotationPackage.Literals.RATIO__VALUE));
        } else {
            this.setRatio(-1.0);
        }
    }

    protected void refreshCollapsed() {
        DrawerStyle style = (DrawerStyle)((View)this.getModel()).getStyle(NotationPackage.Literals.DRAWER_STYLE);
        if (style != null) {
            this.setCollapsed(style.isCollapsed(), false);
        }
    }

    protected void setCollapsed(boolean collapsed, boolean animate) {
        ResizableCompartmentFigure compartmentFigure = this.getCompartmentFigure();
        if (compartmentFigure != null) {
            if (collapsed) {
                if (animate) {
                    compartmentFigure.collapse();
                } else {
                    compartmentFigure.setCollapsed();
                }
            } else if (animate) {
                compartmentFigure.expand();
            } else {
                compartmentFigure.setExpanded();
            }
        }
    }

    protected void setRatio(Double ratio) {
        ((IGraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, this.getFigure(), ratio);
    }

    protected void setShowCompartmentTitle(boolean showCompartmentTitle) {
        ResizableCompartmentFigure compartmentFigure = this.getCompartmentFigure();
        if (compartmentFigure != null) {
            compartmentFigure.setTitleVisibility(showCompartmentTitle);
        }
    }
}

