/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.ui.internal.compare;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.cdo.common.lob.CDOClob;
import org.eclipse.emf.cdo.eresource.CDOBinaryResource;
import org.eclipse.emf.cdo.eresource.CDOFileResource;
import org.eclipse.emf.cdo.eresource.CDOTextResource;
import org.eclipse.emf.cdo.ui.internal.compare.bundle.OM;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.rcp.ui.internal.contentmergeviewer.accessor.impl.MatchAccessor;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.IMergeViewer;
import org.eclipse.net4j.util.io.ReaderInputStream;

public class CDOMatchAccessor
extends MatchAccessor
implements IStreamContentAccessor,
org.eclipse.emf.compare.rcp.ui.contentmergeviewer.accessor.legacy.IStreamContentAccessor {
    private final CDOFileResource<?> file;

    public CDOMatchAccessor(AdapterFactory adapterFactory, Match match, CDOFileResource<?> file, IMergeViewer.MergeViewerSide side) {
        super(adapterFactory, match, side);
        this.file = file;
    }

    public InputStream getContents() throws CoreException {
        try {
            if (this.file instanceof CDOTextResource) {
                CDOTextResource text = (CDOTextResource)this.file;
                CDOClob clob = text.getContents();
                return new ReaderInputStream(clob.getContents(), text.getEncoding());
            }
            CDOBinaryResource binary = (CDOBinaryResource)this.file;
            return binary.getContents().getContents();
        }
        catch (IOException ex) {
            OM.BUNDLE.coreException((Throwable)ex);
            return null;
        }
    }
}

