/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.resolver;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.osgi.internal.module.ResolverImpl;
import org.eclipse.osgi.internal.resolver.BundleDescriptionImpl;
import org.eclipse.osgi.internal.resolver.BundleSpecificationImpl;
import org.eclipse.osgi.internal.resolver.ExportPackageDescriptionImpl;
import org.eclipse.osgi.internal.resolver.GenericDescriptionImpl;
import org.eclipse.osgi.internal.resolver.GenericSpecificationImpl;
import org.eclipse.osgi.internal.resolver.HostSpecificationImpl;
import org.eclipse.osgi.internal.resolver.ImportPackageSpecificationImpl;
import org.eclipse.osgi.internal.resolver.NativeCodeDescriptionImpl;
import org.eclipse.osgi.internal.resolver.NativeCodeSpecificationImpl;
import org.eclipse.osgi.internal.resolver.StateBuilder;
import org.eclipse.osgi.internal.resolver.StateImpl;
import org.eclipse.osgi.internal.resolver.StateReader;
import org.eclipse.osgi.internal.resolver.StateWriter;
import org.eclipse.osgi.internal.resolver.UserState;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.DisabledInfo;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.GenericDescription;
import org.eclipse.osgi.service.resolver.GenericSpecification;
import org.eclipse.osgi.service.resolver.HostSpecification;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.osgi.service.resolver.NativeCodeDescription;
import org.eclipse.osgi.service.resolver.NativeCodeSpecification;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.StateObjectFactory;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.eclipse.osgi.storagemanager.StorageManager;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.BundleException;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.Version;

public class StateObjectFactoryImpl
implements StateObjectFactory {
    @Deprecated
    public BundleDescription createBundleDescription(Dictionary<String, String> manifest, String location, long id) throws BundleException {
        return this.createBundleDescription(null, manifest, location, id);
    }

    public BundleDescription createBundleDescription(State state, Dictionary<String, String> manifest, String location, long id) throws BundleException {
        BundleDescriptionImpl result = (BundleDescriptionImpl)StateBuilder.createBundleDescription((StateImpl)state, manifest, location);
        result.setBundleId(id);
        return result;
    }

    @Deprecated
    public BundleDescription createBundleDescription(long id, String symbolicName, Version version, String location, BundleSpecification[] required, HostSpecification host, ImportPackageSpecification[] imports, ExportPackageDescription[] exports, String[] providedPackages, boolean singleton) {
        return this.createBundleDescription(id, symbolicName, version, location, required, host, imports, exports, providedPackages, singleton, true, true, null, null, null, null);
    }

    @Deprecated
    public BundleDescription createBundleDescription(long id, String symbolicName, Version version, String location, BundleSpecification[] required, HostSpecification host, ImportPackageSpecification[] imports, ExportPackageDescription[] exports, String[] providedPackages, boolean singleton, boolean attachFragments, boolean dynamicFragments, String platformFilter, String executionEnvironment, GenericSpecification[] genericRequires, GenericDescription[] genericCapabilities) {
        return this.createBundleDescription(id, symbolicName, version, location, required, host, imports, exports, singleton, attachFragments, dynamicFragments, platformFilter, ManifestElement.getArrayFromList((String)executionEnvironment), genericRequires, genericCapabilities);
    }

    public BundleDescription createBundleDescription(long id, String symbolicName, Version version, String location, BundleSpecification[] required, HostSpecification host, ImportPackageSpecification[] imports, ExportPackageDescription[] exports, boolean singleton, boolean attachFragments, boolean dynamicFragments, String platformFilter, String[] executionEnvironments, GenericSpecification[] genericRequires, GenericDescription[] genericCapabilities) {
        return this.createBundleDescription(id, symbolicName, version, location, required, host, imports, exports, singleton, attachFragments, dynamicFragments, platformFilter, executionEnvironments, genericRequires, genericCapabilities, null);
    }

    public BundleDescription createBundleDescription(long id, String symbolicName, Version version, String location, BundleSpecification[] required, HostSpecification host, ImportPackageSpecification[] imports, ExportPackageDescription[] exports, boolean singleton, boolean attachFragments, boolean dynamicFragments, String platformFilter, String[] executionEnvironments, GenericSpecification[] genericRequires, GenericDescription[] genericCapabilities, NativeCodeSpecification nativeCode) {
        BundleDescriptionImpl bundle = new BundleDescriptionImpl();
        bundle.setBundleId(id);
        bundle.setSymbolicName(symbolicName);
        bundle.setVersion(version);
        bundle.setLocation(location);
        bundle.setRequiredBundles(required);
        bundle.setHost(host);
        bundle.setImportPackages(imports);
        bundle.setExportPackages(exports);
        bundle.setStateBit(2, singleton);
        bundle.setStateBit(64, attachFragments);
        bundle.setStateBit(128, dynamicFragments);
        bundle.setPlatformFilter(platformFilter);
        bundle.setExecutionEnvironments(executionEnvironments);
        bundle.setGenericRequires(genericRequires);
        bundle.setGenericCapabilities(genericCapabilities);
        bundle.setNativeCodeSpecification(nativeCode);
        return bundle;
    }

    public BundleDescription createBundleDescription(long id, String symbolicName, Version version, String location, BundleSpecification[] required, HostSpecification host, ImportPackageSpecification[] imports, ExportPackageDescription[] exports, String platformFilter, String[] executionEnvironments, GenericSpecification[] genericRequires, GenericDescription[] genericCapabilities, NativeCodeSpecification nativeCode) {
        BundleDescriptionImpl bundle = new BundleDescriptionImpl();
        bundle.setBundleId(id);
        try {
            ManifestElement[] symbolicNameElements = ManifestElement.parseHeader((String)"Bundle-SymbolicName", (String)symbolicName);
            if (symbolicNameElements != null && symbolicNameElements.length > 0) {
                ManifestElement bsnElement = symbolicNameElements[0];
                bundle.setSymbolicName(bsnElement.getValue());
                bundle.setStateBit(2, "true".equals(bsnElement.getDirective("singleton")));
                String fragmentAttachment = bsnElement.getDirective("fragment-attachment");
                if (fragmentAttachment != null) {
                    if (fragmentAttachment.equals("resolve-time")) {
                        bundle.setStateBit(64, true);
                        bundle.setStateBit(128, false);
                    } else if (fragmentAttachment.equals("never")) {
                        bundle.setStateBit(64, false);
                        bundle.setStateBit(128, false);
                    }
                }
                bundle.setDirective("mandatory", ManifestElement.getArrayFromList((String)bsnElement.getDirective("mandatory")));
                bundle.setAttributes(StateBuilder.getAttributes(bsnElement, StateBuilder.DEFINED_BSN_MATCHING_ATTRS));
                bundle.setArbitraryDirectives(StateBuilder.getDirectives(bsnElement, StateBuilder.DEFINED_BSN_DIRECTIVES));
            }
        }
        catch (BundleException e) {
            throw new IllegalArgumentException("Illegal symbolic name: " + symbolicName, e);
        }
        bundle.setVersion(version);
        bundle.setLocation(location);
        bundle.setRequiredBundles(required);
        bundle.setHost(host);
        bundle.setImportPackages(imports);
        bundle.setExportPackages(exports);
        bundle.setPlatformFilter(platformFilter);
        bundle.setExecutionEnvironments(executionEnvironments);
        bundle.setGenericRequires(genericRequires);
        ArrayList<GenericDescription> includeIdentity = new ArrayList<GenericDescription>(genericCapabilities == null ? 1 : genericCapabilities.length + 1);
        GenericDescription genericIdentity = StateBuilder.createOsgiIdentityCapability(bundle);
        if (genericIdentity != null) {
            includeIdentity.add(genericIdentity);
        }
        if (genericCapabilities != null) {
            Collections.addAll(includeIdentity, genericCapabilities);
        }
        if (!includeIdentity.isEmpty()) {
            bundle.setGenericCapabilities(includeIdentity.toArray(new GenericDescription[includeIdentity.size()]));
        }
        bundle.setNativeCodeSpecification(nativeCode);
        return bundle;
    }

    public BundleDescription createBundleDescription(BundleDescription original) {
        BundleDescriptionImpl bundle = new BundleDescriptionImpl();
        bundle.setBundleId(original.getBundleId());
        bundle.setSymbolicName(original.getSymbolicName());
        bundle.setVersion(original.getVersion());
        bundle.setLocation(original.getLocation());
        BundleSpecification[] originalRequired = original.getRequiredBundles();
        BundleSpecification[] newRequired = new BundleSpecification[originalRequired.length];
        int i = 0;
        while (i < newRequired.length) {
            newRequired[i] = this.createBundleSpecification(originalRequired[i]);
            ++i;
        }
        bundle.setRequiredBundles(newRequired);
        ExportPackageDescription[] originalExports = original.getExportPackages();
        ExportPackageDescription[] newExports = new ExportPackageDescription[originalExports.length];
        int i2 = 0;
        while (i2 < newExports.length) {
            newExports[i2] = this.createExportPackageDescription(originalExports[i2]);
            ++i2;
        }
        bundle.setExportPackages(newExports);
        ImportPackageSpecification[] originalImports = original.getImportPackages();
        ImportPackageSpecification[] newImports = new ImportPackageSpecification[originalImports.length];
        int i3 = 0;
        while (i3 < newImports.length) {
            newImports[i3] = this.createImportPackageSpecification(originalImports[i3]);
            ++i3;
        }
        bundle.setImportPackages(newImports);
        if (original.getHost() != null) {
            bundle.setHost(this.createHostSpecification(original.getHost()));
        }
        bundle.setStateBit(2, original.isSingleton());
        bundle.setStateBit(64, original.attachFragments());
        bundle.setStateBit(128, original.dynamicFragments());
        bundle.setStateBit(32, original.hasDynamicImports());
        bundle.setPlatformFilter(original.getPlatformFilter());
        bundle.setExecutionEnvironments(original.getExecutionEnvironments());
        bundle.setGenericCapabilities(this.createGenericCapabilities(original.getGenericCapabilities()));
        bundle.setGenericRequires(this.createGenericRequires(original.getGenericRequires()));
        bundle.setNativeCodeSpecification(this.createNativeCodeSpecification(original.getNativeCodeSpecification()));
        bundle.setAttributes(original.getAttributes());
        if (original instanceof BundleDescriptionImpl) {
            bundle.setDirective("mandatory", ((BundleDescriptionImpl)original).getDirective("mandatory"));
            bundle.setArbitraryDirectives(((BundleDescriptionImpl)original).getArbitraryDirectives());
        }
        return bundle;
    }

    private NativeCodeSpecification createNativeCodeSpecification(NativeCodeSpecification original) {
        if (original == null) {
            return null;
        }
        NativeCodeSpecificationImpl result = new NativeCodeSpecificationImpl();
        result.setName(original.getName());
        result.setOptional(original.isOptional());
        NativeCodeDescription[] originalDescriptions = original.getPossibleSuppliers();
        NativeCodeDescription[] newDescriptions = new NativeCodeDescriptionImpl[originalDescriptions.length];
        int i = 0;
        while (i < originalDescriptions.length) {
            newDescriptions[i] = new NativeCodeDescriptionImpl();
            newDescriptions[i].setName(originalDescriptions[i].getName());
            newDescriptions[i].setNativePaths(originalDescriptions[i].getNativePaths());
            newDescriptions[i].setProcessors(originalDescriptions[i].getProcessors());
            newDescriptions[i].setOSNames(originalDescriptions[i].getOSNames());
            newDescriptions[i].setOSVersions(originalDescriptions[i].getOSVersions());
            newDescriptions[i].setLanguages(originalDescriptions[i].getLanguages());
            try {
                newDescriptions[i].setFilter(originalDescriptions[i].getFilter() == null ? null : originalDescriptions[i].getFilter().toString());
            }
            catch (InvalidSyntaxException invalidSyntaxException) {
                // empty catch block
            }
            ++i;
        }
        result.setPossibleSuppliers(newDescriptions);
        return result;
    }

    private GenericDescription[] createGenericCapabilities(GenericDescription[] genericCapabilities) {
        if (genericCapabilities == null || genericCapabilities.length == 0) {
            return null;
        }
        GenericDescription[] result = new GenericDescription[genericCapabilities.length];
        int i = 0;
        while (i < genericCapabilities.length) {
            GenericDescriptionImpl cap = new GenericDescriptionImpl();
            cap.setType(genericCapabilities[i].getType());
            cap.setAttributes(genericCapabilities[i].getAttributes());
            cap.setDirectives(genericCapabilities[i].getDeclaredDirectives());
            result[i] = cap;
            ++i;
        }
        return result;
    }

    private GenericSpecification[] createGenericRequires(GenericSpecification[] genericRequires) {
        if (genericRequires == null || genericRequires.length == 0) {
            return null;
        }
        GenericSpecification[] result = new GenericSpecification[genericRequires.length];
        int i = 0;
        while (i < genericRequires.length) {
            GenericSpecificationImpl req = new GenericSpecificationImpl();
            req.setName(genericRequires[i].getName());
            req.setType(genericRequires[i].getType());
            req.setResolution(genericRequires[i].getResolution());
            try {
                req.setMatchingFilter(genericRequires[i].getMatchingFilter(), false);
            }
            catch (InvalidSyntaxException invalidSyntaxException) {
                // empty catch block
            }
            if (genericRequires[i] instanceof GenericSpecificationImpl) {
                req.setAttributes(((GenericSpecificationImpl)genericRequires[i]).getAttributes());
                req.setArbitraryDirectives(((GenericSpecificationImpl)genericRequires[i]).getArbitraryDirectives());
            }
            result[i] = req;
            ++i;
        }
        return result;
    }

    public BundleSpecification createBundleSpecification(String requiredSymbolicName, VersionRange requiredVersionRange, boolean export, boolean optional) {
        BundleSpecificationImpl bundleSpec = new BundleSpecificationImpl();
        bundleSpec.setName(requiredSymbolicName);
        bundleSpec.setVersionRange(requiredVersionRange);
        bundleSpec.setExported(export);
        bundleSpec.setOptional(optional);
        return bundleSpec;
    }

    public BundleSpecification createBundleSpecification(BundleSpecification original) {
        BundleSpecificationImpl bundleSpec = new BundleSpecificationImpl();
        bundleSpec.setName(original.getName());
        bundleSpec.setVersionRange(original.getVersionRange());
        bundleSpec.setExported(original.isExported());
        bundleSpec.setOptional(original.isOptional());
        if (original instanceof BundleSpecificationImpl) {
            bundleSpec.setAttributes(((BundleSpecificationImpl)original).getAttributes());
            bundleSpec.setArbitraryDirectives(((BundleSpecificationImpl)original).getArbitraryDirectives());
        }
        return bundleSpec;
    }

    public HostSpecification createHostSpecification(String hostSymbolicName, VersionRange versionRange) {
        HostSpecificationImpl hostSpec = new HostSpecificationImpl();
        hostSpec.setName(hostSymbolicName);
        hostSpec.setVersionRange(versionRange);
        return hostSpec;
    }

    public HostSpecification createHostSpecification(HostSpecification original) {
        HostSpecificationImpl hostSpec = new HostSpecificationImpl();
        hostSpec.setName(original.getName());
        hostSpec.setVersionRange(original.getVersionRange());
        if (original instanceof HostSpecificationImpl) {
            hostSpec.setAttributes(((HostSpecificationImpl)original).getAttributes());
            hostSpec.setArbitraryDirectives(((HostSpecificationImpl)original).getArbitraryDirectives());
        }
        return hostSpec;
    }

    public ImportPackageSpecification createImportPackageSpecification(String packageName, VersionRange versionRange, String bundleSymbolicName, VersionRange bundleVersionRange, Map<String, ?> directives, Map<String, ?> attributes, BundleDescription importer) {
        ImportPackageSpecificationImpl packageSpec = new ImportPackageSpecificationImpl();
        packageSpec.setName(packageName);
        packageSpec.setVersionRange(versionRange);
        packageSpec.setBundleSymbolicName(bundleSymbolicName);
        packageSpec.setBundleVersionRange(bundleVersionRange);
        packageSpec.setDirectives(directives);
        packageSpec.setAttributes(attributes);
        packageSpec.setBundle(importer);
        return packageSpec;
    }

    public ImportPackageSpecification createImportPackageSpecification(ImportPackageSpecification original) {
        ImportPackageSpecificationImpl packageSpec = new ImportPackageSpecificationImpl();
        packageSpec.setName(original.getName());
        packageSpec.setVersionRange(original.getVersionRange());
        packageSpec.setBundleSymbolicName(original.getBundleSymbolicName());
        packageSpec.setBundleVersionRange(original.getBundleVersionRange());
        packageSpec.setDirectives(original.getDirectives());
        packageSpec.setAttributes(original.getAttributes());
        if (original instanceof ImportPackageSpecificationImpl) {
            packageSpec.setArbitraryDirectives(((ImportPackageSpecificationImpl)original).getArbitraryDirectives());
        }
        return packageSpec;
    }

    public ExportPackageDescription createExportPackageDescription(ExportPackageDescription original) {
        ExportPackageDescriptionImpl exportPackage = new ExportPackageDescriptionImpl();
        exportPackage.setName(original.getName());
        exportPackage.setVersion(original.getVersion());
        exportPackage.setDirectives(original.getDirectives());
        exportPackage.setAttributes(original.getAttributes());
        exportPackage.setArbitraryDirectives(((ExportPackageDescriptionImpl)original).getArbitraryDirectives());
        return exportPackage;
    }

    public ExportPackageDescription createExportPackageDescription(String packageName, Version version, Map<String, ?> directives, Map<String, ?> attributes, boolean root, BundleDescription exporter) {
        ExportPackageDescriptionImpl exportPackage = new ExportPackageDescriptionImpl();
        exportPackage.setName(packageName);
        exportPackage.setVersion(version);
        exportPackage.setDirectives(directives);
        exportPackage.setAttributes(attributes);
        exportPackage.setExporter(exporter);
        return exportPackage;
    }

    @Deprecated
    public GenericDescription createGenericDescription(String name, String type, Version version, Map<String, ?> attributes) {
        return this.createGenericDescription(name, type, version, attributes, null, null);
    }

    public GenericDescription createGenericDescription(String type, Map<String, ?> attributes, Map<String, String> directives, BundleDescription supplier) {
        return this.createGenericDescription(null, type, null, attributes, directives, supplier);
    }

    private GenericDescription createGenericDescription(String name, String type, Version version, Map<String, ?> attributes, Map<String, String> directives, BundleDescription supplier) {
        Object nameObj;
        Object versionObj;
        Hashtable<String, Object> attrs;
        GenericDescriptionImpl result = new GenericDescriptionImpl();
        result.setType(type);
        Hashtable<String, Object> hashtable = attrs = attributes == null ? new Hashtable<String, Object>() : new Hashtable(attributes);
        if (version != null && !((versionObj = ((Dictionary)attrs).get("version")) instanceof Version) && version != null) {
            ((Dictionary)attrs).put("version", version);
        }
        if (name != null && !((nameObj = ((Dictionary)attrs).get(result.getType())) instanceof String)) {
            ((Dictionary)attrs).put(result.getType(), name);
        }
        result.setAttributes(attrs);
        result.setDirectives(directives);
        result.setSupplier(supplier);
        return result;
    }

    public GenericSpecification createGenericSpecification(String name, String type, String matchingFilter, boolean optional, boolean multiple) throws InvalidSyntaxException {
        GenericSpecificationImpl result = new GenericSpecificationImpl();
        result.setName(name);
        result.setType(type);
        result.setMatchingFilter(matchingFilter, true);
        int resolution = 0;
        if (optional) {
            resolution |= 1;
        }
        if (multiple) {
            resolution |= 2;
        }
        result.setResolution(resolution);
        return result;
    }

    public NativeCodeDescription createNativeCodeDescription(String[] nativePaths, String[] processors, String[] osNames, VersionRange[] osVersions, String[] languages, String filter) throws InvalidSyntaxException {
        NativeCodeDescriptionImpl result = new NativeCodeDescriptionImpl();
        result.setName("Bundle-NativeCode");
        result.setNativePaths(nativePaths);
        result.setProcessors(processors);
        result.setOSNames(osNames);
        result.setOSVersions(osVersions);
        result.setLanguages(languages);
        result.setFilter(filter);
        return result;
    }

    public NativeCodeSpecification createNativeCodeSpecification(NativeCodeDescription[] nativeCodeDescriptions, boolean optional) {
        NativeCodeSpecificationImpl result = new NativeCodeSpecificationImpl();
        result.setName("Bundle-NativeCode");
        result.setOptional(optional);
        result.setPossibleSuppliers(nativeCodeDescriptions);
        return result;
    }

    @Deprecated
    public State createState() {
        return this.internalCreateState();
    }

    public State createState(boolean createResolver) {
        StateImpl result = this.internalCreateState();
        if (createResolver) {
            result.setResolver(new ResolverImpl(false));
        }
        return result;
    }

    public State createState(State original) {
        BundleDescription[] bundles;
        StateImpl newState = this.internalCreateState();
        newState.setTimeStamp(original.getTimeStamp());
        BundleDescription[] bundleDescriptionArray = bundles = original.getBundles();
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            DisabledInfo[] infos;
            BundleDescription bundle = bundleDescriptionArray[n2];
            BundleDescription newBundle = this.createBundleDescription(bundle);
            newState.basicAddBundle(newBundle);
            DisabledInfo[] disabledInfoArray = infos = original.getDisabledInfos(bundle);
            int n3 = infos.length;
            int n4 = 0;
            while (n4 < n3) {
                DisabledInfo info = disabledInfoArray[n4];
                newState.addDisabledInfo(new DisabledInfo(info.getPolicyName(), info.getMessage(), newBundle));
                ++n4;
            }
            ++n2;
        }
        newState.setResolved(false);
        newState.setPlatformProperties(original.getPlatformProperties());
        return newState;
    }

    private StateImpl internalCreateState() {
        UserState state = new UserState();
        state.setFactory(this);
        return state;
    }

    @Deprecated
    public State readState(InputStream stream) throws IOException {
        return this.internalReadStateDeprecated(this.internalCreateState(), new DataInputStream(stream), -1L);
    }

    @Deprecated
    public State readState(DataInputStream stream) throws IOException {
        return this.internalReadStateDeprecated(this.internalCreateState(), stream, -1L);
    }

    public State readState(File stateDirectory) throws IOException {
        return this.internalReadState(this.internalCreateState(), stateDirectory, -1L);
    }

    private State internalReadStateDeprecated(StateImpl toRestore, DataInputStream stream, long expectedTimestamp) throws IOException {
        StateReader reader = new StateReader();
        if (!reader.loadStateDeprecated(toRestore, stream, expectedTimestamp)) {
            return null;
        }
        return toRestore;
    }

    private State internalReadState(StateImpl toRestore, File stateDirectory, long expectedTimestamp) throws IOException {
        StateReader reader;
        File stateFile = new File(stateDirectory, ".state");
        File lazyFile = new File(stateDirectory, ".lazy");
        if (!stateFile.exists() || !lazyFile.exists()) {
            try (StorageManager storageManager = new StorageManager(stateDirectory, "none", true);){
                storageManager.open(true);
                File managedState = storageManager.lookup(".state", false);
                File managedLazy = storageManager.lookup(".lazy", false);
                if (managedState != null && managedLazy != null) {
                    stateFile = managedState;
                    lazyFile = managedLazy;
                }
            }
        }
        if (!(reader = new StateReader(stateFile, lazyFile, false)).loadState(toRestore, expectedTimestamp)) {
            return null;
        }
        return toRestore;
    }

    @Deprecated
    public void writeState(State state, DataOutputStream stream) throws IOException {
        this.internalWriteStateDeprecated(state, stream);
    }

    public void writeState(State state, File stateDirectory) throws IOException {
        if (stateDirectory == null) {
            throw new IOException();
        }
        StateWriter writer = new StateWriter();
        File stateFile = new File(stateDirectory, ".state");
        File lazyFile = new File(stateDirectory, ".lazy");
        writer.saveState((StateImpl)state, stateFile, lazyFile);
    }

    @Deprecated
    public void writeState(State state, OutputStream stream) throws IOException {
        this.internalWriteStateDeprecated(state, new DataOutputStream(stream));
    }

    public void writeState(State state, File stateFile, File lazyFile) throws IOException {
        StateWriter writer = new StateWriter();
        writer.saveState((StateImpl)state, stateFile, lazyFile);
    }

    private void internalWriteStateDeprecated(State state, DataOutputStream stream) throws IOException {
        if (state.getFactory() != this) {
            throw new IllegalArgumentException();
        }
        StateWriter writer = new StateWriter();
        writer.saveStateDeprecated((StateImpl)state, stream);
    }

    public List<BundleSpecification> createBundleSpecifications(String declaration) {
        try {
            ManifestElement[] elements = ManifestElement.parseHeader((String)"Require-Bundle", (String)declaration);
            if (elements == null) {
                return Collections.emptyList();
            }
            ArrayList<BundleSpecification> result = new ArrayList<BundleSpecification>(elements.length);
            ManifestElement[] manifestElementArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                ManifestElement element = manifestElementArray[n2];
                result.add(StateBuilder.createRequiredBundle(element));
                ++n2;
            }
            return result;
        }
        catch (BundleException e) {
            throw new IllegalArgumentException("Declaration is invalid: " + declaration, e);
        }
    }

    public List<HostSpecification> createHostSpecifications(String declaration) {
        try {
            ManifestElement[] elements = ManifestElement.parseHeader((String)"Fragment-Host", (String)declaration);
            if (elements == null) {
                return Collections.emptyList();
            }
            ArrayList<HostSpecification> result = new ArrayList<HostSpecification>(elements.length);
            ManifestElement[] manifestElementArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                ManifestElement element = manifestElementArray[n2];
                result.add(StateBuilder.createHostSpecification(element, null));
                ++n2;
            }
            return result;
        }
        catch (BundleException e) {
            throw new IllegalArgumentException("Declaration is invalid: " + declaration, e);
        }
    }

    public List<ImportPackageSpecification> createImportPackageSpecifications(String declaration) {
        try {
            ManifestElement[] elements = ManifestElement.parseHeader((String)"Import-Package", (String)declaration);
            if (elements == null) {
                return Collections.emptyList();
            }
            ArrayList<ImportPackageSpecification> result = new ArrayList<ImportPackageSpecification>(elements.length);
            ManifestElement[] manifestElementArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                ManifestElement element = manifestElementArray[n2];
                StateBuilder.addImportPackages(element, result, 2, false);
                ++n2;
            }
            return result;
        }
        catch (BundleException e) {
            throw new IllegalArgumentException("Declaration is invalid: " + declaration, e);
        }
    }

    public List<GenericDescription> createGenericDescriptions(String declaration) {
        try {
            ManifestElement[] elements = ManifestElement.parseHeader((String)"Provide-Capability", (String)declaration);
            if (elements == null) {
                return Collections.emptyList();
            }
            return StateBuilder.createOSGiCapabilities(elements, new ArrayList<GenericDescription>(elements.length), null);
        }
        catch (BundleException e) {
            throw new IllegalArgumentException("Declaration is invalid: " + declaration, e);
        }
    }

    public List<GenericSpecification> createGenericSpecifications(String declaration) {
        try {
            ManifestElement[] elements = ManifestElement.parseHeader((String)"Require-Capability", (String)declaration);
            if (elements == null) {
                return Collections.emptyList();
            }
            return StateBuilder.createOSGiRequires(elements, new ArrayList<GenericSpecification>(elements.length));
        }
        catch (BundleException e) {
            throw new IllegalArgumentException("Declaration is invalid: " + declaration, e);
        }
    }

    public List<ExportPackageDescription> createExportPackageDescriptions(String declaration) {
        try {
            ManifestElement[] elements = ManifestElement.parseHeader((String)"Import-Package", (String)declaration);
            if (elements == null) {
                return Collections.emptyList();
            }
            ArrayList<ExportPackageDescription> result = new ArrayList<ExportPackageDescription>(elements.length);
            ManifestElement[] manifestElementArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                ManifestElement element = manifestElementArray[n2];
                StateBuilder.addExportPackages(element, result, false);
                ++n2;
            }
            return result;
        }
        catch (BundleException e) {
            throw new IllegalArgumentException("Declaration is invalid: " + declaration, e);
        }
    }
}

