/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.github.core.service;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import org.eclipse.egit.github.core.IRepositoryIdProvider;
import org.eclipse.egit.github.core.client.GitHubClient;
import org.eclipse.egit.github.core.service.GitHubService;

public class MarkdownService
extends GitHubService {
    public static final String MODE_GFM = "gfm";
    public static final String MODE_MARKDOWN = "markdown";

    public MarkdownService() {
    }

    public MarkdownService(GitHubClient client) {
        super(client);
    }

    private String readStream(InputStream stream) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
        try {
            int read;
            StringBuilder output = new StringBuilder();
            char[] buffer = new char[8192];
            while ((read = reader.read(buffer)) != -1) {
                output.append(buffer, 0, read);
            }
            String string = output.toString();
            return string;
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
    }

    public InputStream getRepositoryStream(IRepositoryIdProvider repo, String text) throws IOException {
        String context = this.getId(repo);
        HashMap<String, String> params = new HashMap<String, String>(3, 1.0f);
        params.put("context", context);
        params.put("text", text);
        params.put("mode", MODE_GFM);
        return this.client.postStream("/markdown", params);
    }

    public String getRepositoryHtml(IRepositoryIdProvider repo, String text) throws IOException {
        return this.readStream(this.getRepositoryStream(repo, text));
    }

    public InputStream getStream(String text, String mode) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>(2, 1.0f);
        params.put("text", text);
        params.put("mode", mode);
        return this.client.postStream("/markdown", params);
    }

    public String getHtml(String text, String mode) throws IOException {
        return this.readStream(this.getStream(text, mode));
    }
}

