/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.indexing;

import java.io.IOException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.internal.core.index.Index;
import org.eclipse.jdt.internal.core.search.indexing.IndexManager;
import org.eclipse.jdt.internal.core.search.indexing.IndexRequest;
import org.eclipse.jdt.internal.core.search.indexing.ReadWriteMonitor;
import org.eclipse.jdt.internal.core.util.Util;

class RemoveFolderFromIndex
extends IndexRequest {
    IPath folderPath;
    char[][] inclusionPatterns;
    char[][] exclusionPatterns;

    public RemoveFolderFromIndex(IPath folderPath, char[][] inclusionPatterns, char[][] exclusionPatterns, IProject project, IndexManager manager) {
        super(project.getFullPath(), manager);
        this.folderPath = folderPath;
        this.inclusionPatterns = inclusionPatterns;
        this.exclusionPatterns = exclusionPatterns;
    }

    @Override
    public boolean execute(IProgressMonitor progressMonitor) {
        if (this.isCancelled || progressMonitor != null && progressMonitor.isCanceled()) {
            return true;
        }
        Index index = this.manager.getIndex(this.containerPath, true, false);
        if (index == null) {
            return true;
        }
        ReadWriteMonitor monitor = index.monitor;
        if (monitor == null) {
            return true;
        }
        try {
            try {
                monitor.enterRead();
                String containerRelativePath = Util.relativePath(this.folderPath, this.containerPath.segmentCount());
                String[] paths = index.queryDocumentNames(containerRelativePath);
                if (paths != null) {
                    if (this.exclusionPatterns == null && this.inclusionPatterns == null) {
                        String[] stringArray = paths;
                        int n = paths.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String path = stringArray[n2];
                            this.manager.remove(path, this.containerPath);
                            ++n2;
                        }
                    } else {
                        String[] stringArray = paths;
                        int n = paths.length;
                        int n3 = 0;
                        while (n3 < n) {
                            String path = stringArray[n3];
                            String documentPath = this.containerPath.toString() + "/" + path;
                            if (!Util.isExcluded((IPath)new Path(documentPath), this.inclusionPatterns, this.exclusionPatterns, false)) {
                                this.manager.remove(path, this.containerPath);
                            }
                            ++n3;
                        }
                    }
                }
            }
            catch (IOException e) {
                Util.log(e, "Failed to remove " + String.valueOf(this.folderPath) + " from index: " + e.getMessage());
                monitor.exitRead();
                return false;
            }
        }
        finally {
            monitor.exitRead();
        }
        return true;
    }

    public String toString() {
        return "removing " + String.valueOf(this.folderPath) + " from index " + String.valueOf(this.containerPath);
    }
}

