/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.business.internal.migration;

import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.gmf.runtime.notation.ConnectorStyle;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.Routing;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DiagramPackage;
import org.eclipse.sirius.diagram.EdgeRouting;
import org.eclipse.sirius.diagram.EdgeStyle;
import org.eclipse.sirius.diagram.description.DescriptionPackage;
import org.osgi.framework.Version;

public class DiagramRepresentationsFileMigrationParticipantV690 {
    public static final Version MIGRATION_VERSION = new Version("6.9.0.201309101020");

    public EClassifier getType(EPackage ePackage, String name) {
        HashSet<String> descriptionsNsUri = new HashSet<String>(Arrays.asList(DescriptionPackage.eINSTANCE.getNsURI(), org.eclipse.sirius.viewpoint.description.DescriptionPackage.eINSTANCE.getNsURI()));
        if (ePackage != null && ePackage.getNsURI() != null && descriptionsNsUri.contains(ePackage.getNsURI()) && name.equals("OptionalLayer")) {
            return DescriptionPackage.eINSTANCE.getAdditionalLayer();
        }
        return null;
    }

    public void migrateEdgeRoutingStyle(List<Diagram> diagrams) {
        for (Diagram diagram : diagrams) {
            for (Edge edge : Iterables.filter((Iterable)diagram.getEdges(), Edge.class)) {
                if (!this.isConcernedEdge(edge)) continue;
                DEdge dEdge = (DEdge)edge.getElement();
                EdgeStyle edgeStyle = dEdge.getOwnedStyle();
                edgeStyle.setRoutingStyle(EdgeRouting.MANHATTAN_LITERAL);
                edgeStyle.getCustomFeatures().add((Object)DiagramPackage.Literals.EDGE_STYLE__ROUTING_STYLE.getName());
            }
        }
    }

    public void migrateVisibilityInconsistenciesBetweenGMFNodeAndDDiagramElement(List<Diagram> diagrams) {
        for (Diagram diagram : diagrams) {
            UnmodifiableIterator iterator = Iterators.filter((Iterator)diagram.eAllContents(), Node.class);
            while (iterator.hasNext()) {
                EObject element;
                Node node = (Node)iterator.next();
                if (!node.isSetElement() || !((element = node.getElement()) instanceof DDiagramElement) || ((DDiagramElement)element).isVisible() == node.isVisible()) continue;
                node.setVisible(((DDiagramElement)element).isVisible());
            }
        }
    }

    private boolean isConcernedEdge(Edge edge) {
        DEdge dEdge;
        ConnectorStyle connectorStyle = (ConnectorStyle)edge.getStyle(NotationPackage.eINSTANCE.getConnectorStyle());
        return connectorStyle != null && Routing.RECTILINEAR_LITERAL.equals(connectorStyle.getRouting()) && edge.getElement() instanceof DEdge && EdgeRouting.STRAIGHT_LITERAL.equals((Object)(dEdge = (DEdge)edge.getElement()).getOwnedStyle().getRoutingStyle()) && !dEdge.getOwnedStyle().getCustomFeatures().contains((Object)DiagramPackage.Literals.EDGE_STYLE__ROUTING_STYLE.getName());
    }
}

