/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.menu;

import java.util.HashMap;
import java.util.Objects;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.common.core.service.IProviderChangeListener;
import org.eclipse.gmf.runtime.common.ui.services.action.internal.contributionitem.IContributionItemProvider;
import org.eclipse.gmf.runtime.common.ui.util.IWorkbenchPartDescriptor;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.sirius.business.api.componentization.ViewpointRegistry;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.helper.task.InitInterpreterVariablesTask;
import org.eclipse.sirius.business.api.logger.RuntimeLoggerManager;
import org.eclipse.sirius.business.api.query.DRepresentationQuery;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.business.api.query.EObjectQuery;
import org.eclipse.sirius.diagram.ui.part.SiriusDiagramEditor;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.diagram.ui.tools.internal.commands.emf.EMFCommandFactoryUI;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.tools.api.SiriusPlugin;
import org.eclipse.sirius.tools.api.command.ui.UICallBack;
import org.eclipse.sirius.ui.business.api.dialect.DialectUIManager;
import org.eclipse.sirius.ui.tools.internal.editor.MenuHelper;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.DRepresentationElement;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.eclipse.sirius.viewpoint.description.tool.RepresentationNavigationDescription;
import org.eclipse.sirius.viewpoint.description.tool.ToolPackage;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPart;

public class OpenMenuContribution
implements IContributionItemProvider {
    private static final String MENU_OPEN_REPRESENTATION_ID = "popup.open";
    private AdapterFactory adapterFactory;

    private AdapterFactory getAdapterFactory() {
        if (this.adapterFactory == null) {
            this.adapterFactory = DialectUIManager.INSTANCE.createAdapterFactory();
        }
        return this.adapterFactory;
    }

    public void contributeToPopupMenu(IMenuManager menu, IWorkbenchPart part) {
        SiriusDiagramEditor diagrampart;
        EObject element;
        if (part instanceof SiriusDiagramEditor && (element = (diagrampart = (SiriusDiagramEditor)part).getDiagramEditPart().resolveSemanticElement()) instanceof DSemanticDiagram) {
            IGraphicalEditPart curPart;
            EObject designerObj;
            DSemanticDiagram designerDiag = (DSemanticDiagram)element;
            EditPart editpart = diagrampart.getDiagramGraphicalViewer().getFocusEditPart();
            if (editpart instanceof IGraphicalEditPart && (designerObj = (curPart = (IGraphicalEditPart)editpart).resolveSemanticElement()) instanceof DSemanticDecorator) {
                this.buildOpenExistingRepresentationsMenu(menu, designerDiag, editpart, designerObj);
            }
        }
    }

    private void buildOpenExistingRepresentationsMenu(IMenuManager menu, DSemanticDiagram designerDiag, EditPart editpart, EObject designerObj) {
        Session session;
        EObject semantic = ((DSemanticDecorator)designerObj).getTarget();
        if (semantic != null && (session = SessionManager.INSTANCE.getSession(semantic)) != null) {
            menu.insertBefore("additions", (IContributionItem)new Separator("generator"));
            IMenuManager navigateManager = (IMenuManager)menu.find("navigateMenu");
            if (navigateManager != null) {
                navigateManager.remove("open");
            }
            MenuManager openMenuManager = new MenuManager(Messages.OpenMenuContribution_menuLabel, MENU_OPEN_REPRESENTATION_ID);
            if (!menu.isEmpty()) {
                menu.insertBefore(menu.getItems()[0].getId(), (IContributionItem)openMenuManager);
            } else {
                menu.add((IContributionItem)openMenuManager);
            }
            this.contributeToPopupMenu((IMenuManager)openMenuManager, null);
            TransactionalEditingDomain transDomain = TransactionUtil.getEditingDomain((EObject)designerDiag);
            DRepresentationDescriptor representationDescriptor = new DRepresentationQuery((DRepresentation)designerDiag).getRepresentationDescriptor();
            DialectManager.INSTANCE.getAllRepresentationDescriptors(session).stream().filter(rd -> !Objects.equals(rd, representationDescriptor)).filter(repDesc -> Objects.equals(repDesc.getTarget(), semantic)).filter(repDesc -> this.isFromActiveViewpoint(session, repDesc.getDescription())).forEach(repDesc -> openMenuManager.add(MenuHelper.buildOpenRepresentationAction((Session)session, (DRepresentationDescriptor)repDesc, (AdapterFactory)this.getAdapterFactory())));
            if (designerObj instanceof DRepresentationElement) {
                this.buildOpenableRepresentationsMenu((IMenuManager)openMenuManager, designerObj, session, editpart, transDomain);
            }
        }
    }

    private boolean isFromActiveViewpoint(Session session, RepresentationDescription representationDescription) {
        Viewpoint vp = ViewpointRegistry.getInstance().getViewpoint(representationDescription);
        return vp != null && session.getSelectedViewpoints(false).contains(vp);
    }

    private boolean isFromActiveViewpoint(Session session, DRepresentation representation) {
        RepresentationDescription description = DialectManager.INSTANCE.getDescription(representation);
        return this.isFromActiveViewpoint(session, description);
    }

    private void buildOpenableRepresentationsMenu(IMenuManager openMenu, EObject designerObj, Session session, EditPart editpart, TransactionalEditingDomain transDomain) {
        DRepresentationElement element = (DRepresentationElement)designerObj;
        Separator createGroup = new Separator("openRepresentationGroup");
        openMenu.add((IContributionItem)createGroup);
        for (RepresentationNavigationDescription navDesc : element.getMapping().getNavigationDescriptions()) {
            boolean append = true;
            if (!this.isFromActiveViewpoint(session, navDesc.getRepresentationDescription())) {
                append = false;
            }
            IInterpreter interpreter = SiriusPlugin.getDefault().getInterpreterRegistry().getInterpreter(element.getTarget());
            Option diagram = new EObjectQuery((EObject)element).getParentDiagram();
            if (diagram.some()) {
                interpreter.setVariable("diagram", diagram.get());
            } else {
                interpreter.setVariable("diagram", null);
            }
            HashMap<Object, Object> variables = new HashMap<Object, Object>();
            variables.put(navDesc.getContainerVariable(), element.getTarget());
            variables.put(navDesc.getContainerViewVariable(), element);
            InitInterpreterVariablesTask init = new InitInterpreterVariablesTask(variables, interpreter, (UICallBack)new EMFCommandFactoryUI());
            init.execute();
            String precondition = navDesc.getPrecondition();
            if (append && !StringUtil.isEmpty((String)precondition)) {
                append = false;
                try {
                    append = interpreter.evaluateBoolean(element.getTarget(), navDesc.getPrecondition());
                }
                catch (EvaluationException e) {
                    RuntimeLoggerManager.INSTANCE.error((EObject)navDesc, (EStructuralFeature)ToolPackage.eINSTANCE.getAbstractToolDescription_Precondition(), (Throwable)e);
                }
            }
            if (append) {
                MenuHelper.buildOpenRepresentationActions((IMenuManager)openMenu, (IInterpreter)interpreter, (RepresentationNavigationDescription)navDesc, (DRepresentationElement)element, (Session)session, (AdapterFactory)this.getAdapterFactory());
            }
            interpreter.unSetVariable("diagram");
        }
    }

    public void contributeToActionBars(IActionBars arg0, IWorkbenchPartDescriptor arg1) {
    }

    public void disposeContributions(IWorkbenchPartDescriptor arg0) {
    }

    public void updateActionBars(IActionBars arg0, IWorkbenchPartDescriptor arg1) {
    }

    public void addProviderChangeListener(IProviderChangeListener arg0) {
    }

    public boolean provides(IOperation arg0) {
        return true;
    }

    public void removeProviderChangeListener(IProviderChangeListener arg0) {
    }
}

