/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.git.core;

import java.io.InputStream;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.mylyn.internal.git.core.GitConnector;
import org.eclipse.mylyn.internal.git.core.GitRepository;
import org.eclipse.mylyn.versions.core.ScmArtifact;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.core.history.provider.FileRevision;

public class GitArtifact
extends ScmArtifact {
    private final GitRepository repository;

    public GitArtifact(String id, String path, GitRepository repository) {
        super(id, path);
        this.repository = repository;
    }

    public IFileRevision getFileRevision(IProgressMonitor monitor) {
        try {
            final IPath path = Path.fromPortableString((String)this.getPath());
            return new FileRevision(){

                public IFileRevision withAllProperties(IProgressMonitor monitor) throws CoreException {
                    return this;
                }

                public boolean isPropertyMissing() {
                    return false;
                }

                public IStorage getStorage(IProgressMonitor monitor) throws CoreException {
                    return new IStorage(){

                        public <T> T getAdapter(Class<T> adapter) {
                            return null;
                        }

                        public boolean isReadOnly() {
                            return true;
                        }

                        public String getName() {
                            return path.lastSegment();
                        }

                        public IPath getFullPath() {
                            return path;
                        }

                        public InputStream getContents() throws CoreException {
                            try {
                                return (this).GitArtifact.this.repository.getRepository().open((AnyObjectId)ObjectId.fromString((String)GitArtifact.this.getId()), 3).openStream();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                throw new CoreException((IStatus)new Status(4, GitConnector.PLUGIN_ID, e.getMessage()));
                            }
                        }
                    };
                }

                public String getName() {
                    return path.lastSegment();
                }
            };
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public IFileRevision[] getContributors(IProgressMonitor monitor) {
        throw new UnsupportedOperationException();
    }

    public IFileRevision[] getTargets(IProgressMonitor monitor) {
        throw new UnsupportedOperationException();
    }
}

