/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.commons.repositories.http.core;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Objects;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.scheme.LayeredSchemeSocketFactory;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.eclipse.core.runtime.Assert;
import org.eclipse.mylyn.commons.core.net.NetUtil;
import org.eclipse.mylyn.commons.core.net.SslSupport;
import org.eclipse.mylyn.commons.core.net.TrustAllTrustManager;

public class PollingSslProtocolSocketFactory
implements LayeredSchemeSocketFactory {
    private final SslSupport defaultSslSupport;

    public PollingSslProtocolSocketFactory() {
        this(new SslSupport(new TrustManager[]{new TrustAllTrustManager()}));
    }

    public PollingSslProtocolSocketFactory(SslSupport sslSupport) {
        this.defaultSslSupport = sslSupport;
    }

    public Socket connectSocket(Socket sock, InetSocketAddress remoteAddress, InetSocketAddress localAddress, HttpParams params) throws IOException, UnknownHostException, ConnectTimeoutException {
        Socket socket;
        Assert.isNotNull((Object)params);
        Socket socket2 = socket = sock != null ? sock : this.createSocket(params);
        if (localAddress != null) {
            socket.setReuseAddress(HttpConnectionParams.getSoReuseaddr((HttpParams)params));
            socket.bind(localAddress);
        }
        int connTimeout = HttpConnectionParams.getConnectionTimeout((HttpParams)params);
        socket.connect(remoteAddress, connTimeout);
        if (socket instanceof SSLSocket) {
            return socket;
        }
        return this.getSslSupport(params).getSocketFactory().createSocket(socket, remoteAddress.getHostName(), remoteAddress.getPort(), true);
    }

    public Socket createLayeredSocket(Socket socket, String target, int port, boolean autoClose) throws IOException, UnknownHostException {
        return NetUtil.configureSocket((Socket)this.getDefaultSocketFactory().createSocket(socket, target, port, autoClose));
    }

    public Socket createSocket(HttpParams params) throws IOException {
        Assert.isNotNull((Object)params);
        return NetUtil.configureSocket((Socket)this.getSslSupport(params).getSocketFactory().createSocket());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PollingSslProtocolSocketFactory other = (PollingSslProtocolSocketFactory)obj;
        return Objects.equals(this.defaultSslSupport, other.defaultSslSupport);
    }

    public SSLSocketFactory getDefaultSocketFactory() throws IOException {
        return this.defaultSslSupport.getSocketFactory();
    }

    public int hashCode() {
        return Objects.hash(this.defaultSslSupport);
    }

    public boolean isSecure(Socket socket) throws IllegalArgumentException {
        Assert.isNotNull((Object)socket);
        if (!(socket instanceof SSLSocket)) {
            throw new IllegalArgumentException("Socket is not secure: " + String.valueOf(socket.getClass()));
        }
        if (socket.isClosed()) {
            throw new IllegalArgumentException("Socket is closed");
        }
        return true;
    }

    private SslSupport getSslSupport(HttpParams params) {
        SslSupport sslSupport = (SslSupport)params.getParameter(SslSupport.class.getName());
        return sslSupport != null ? sslSupport : this.defaultSslSupport;
    }
}

