/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.internal.repository.comparator.java;

import java.util.Arrays;
import org.eclipse.equinox.p2.internal.repository.comparator.java.AnnotationDefaultAttribute;
import org.eclipse.equinox.p2.internal.repository.comparator.java.AttributeNamesConstants;
import org.eclipse.equinox.p2.internal.repository.comparator.java.ClassFileAttribute;
import org.eclipse.equinox.p2.internal.repository.comparator.java.ClassFileStruct;
import org.eclipse.equinox.p2.internal.repository.comparator.java.ClassFormatException;
import org.eclipse.equinox.p2.internal.repository.comparator.java.CodeAttribute;
import org.eclipse.equinox.p2.internal.repository.comparator.java.ConstantPool;
import org.eclipse.equinox.p2.internal.repository.comparator.java.ConstantPoolEntry;
import org.eclipse.equinox.p2.internal.repository.comparator.java.ExceptionAttribute;
import org.eclipse.equinox.p2.internal.repository.comparator.java.RuntimeInvisibleAnnotationsAttribute;
import org.eclipse.equinox.p2.internal.repository.comparator.java.RuntimeInvisibleParameterAnnotationsAttribute;
import org.eclipse.equinox.p2.internal.repository.comparator.java.RuntimeVisibleAnnotationsAttribute;
import org.eclipse.equinox.p2.internal.repository.comparator.java.RuntimeVisibleParameterAnnotationsAttribute;
import org.eclipse.equinox.p2.internal.repository.comparator.java.SignatureAttribute;

public class MethodInfo
extends ClassFileStruct {
    private final int accessFlags;
    private final int attributeBytes;
    private ClassFileAttribute[] attributes;
    private final int attributesCount;
    private CodeAttribute codeAttribute;
    private final char[] descriptor;
    private final int descriptorIndex;
    private ExceptionAttribute exceptionAttribute;
    private boolean isDeprecated;
    private boolean isSynthetic;
    private final char[] name;
    private final int nameIndex;

    public MethodInfo(byte[] classFileBytes, ConstantPool constantPool, int offset, int decodingFlags) throws ClassFormatException {
        int flags;
        boolean no_code_attribute = (decodingFlags & 0x20) == 0;
        this.accessFlags = flags = this.u2At(classFileBytes, 0, offset);
        if ((flags & 0x1000) != 0) {
            this.isSynthetic = true;
        }
        this.nameIndex = this.u2At(classFileBytes, 2, offset);
        ConstantPoolEntry constantPoolEntry = constantPool.decodeEntry(this.nameIndex);
        if (constantPoolEntry.getKind() != 1) {
            throw new ClassFormatException(3);
        }
        this.name = constantPoolEntry.getUtf8Value();
        this.descriptorIndex = this.u2At(classFileBytes, 4, offset);
        constantPoolEntry = constantPool.decodeEntry(this.descriptorIndex);
        if (constantPoolEntry.getKind() != 1) {
            throw new ClassFormatException(3);
        }
        this.descriptor = constantPoolEntry.getUtf8Value();
        this.attributesCount = this.u2At(classFileBytes, 6, offset);
        this.attributes = ClassFileAttribute.NO_ATTRIBUTES;
        if (this.attributesCount != 0) {
            if (no_code_attribute && !this.isAbstract() && !this.isNative()) {
                if (this.attributesCount != 1) {
                    this.attributes = new ClassFileAttribute[this.attributesCount - 1];
                }
            } else {
                this.attributes = new ClassFileAttribute[this.attributesCount];
            }
        }
        int attributesIndex = 0;
        int readOffset = 8;
        int i = 0;
        while (i < this.attributesCount) {
            constantPoolEntry = constantPool.decodeEntry(this.u2At(classFileBytes, readOffset, offset));
            if (constantPoolEntry.getKind() != 1) {
                throw new ClassFormatException(3);
            }
            char[] attributeName = constantPoolEntry.getUtf8Value();
            if (Arrays.equals(attributeName, AttributeNamesConstants.DEPRECATED)) {
                this.isDeprecated = true;
                this.attributes[attributesIndex++] = new ClassFileAttribute(classFileBytes, constantPool, offset + readOffset);
            } else if (Arrays.equals(attributeName, AttributeNamesConstants.SYNTHETIC)) {
                this.isSynthetic = true;
                this.attributes[attributesIndex++] = new ClassFileAttribute(classFileBytes, constantPool, offset + readOffset);
            } else if (Arrays.equals(attributeName, AttributeNamesConstants.CODE)) {
                if (!no_code_attribute) {
                    this.codeAttribute = new CodeAttribute(classFileBytes, constantPool, offset + readOffset);
                    this.attributes[attributesIndex++] = this.codeAttribute;
                }
            } else if (Arrays.equals(attributeName, AttributeNamesConstants.EXCEPTIONS)) {
                this.exceptionAttribute = new ExceptionAttribute(classFileBytes, constantPool, offset + readOffset);
                this.attributes[attributesIndex++] = this.exceptionAttribute;
            } else {
                this.attributes[attributesIndex++] = Arrays.equals(attributeName, AttributeNamesConstants.SIGNATURE) ? new SignatureAttribute(classFileBytes, constantPool, offset + readOffset) : (Arrays.equals(attributeName, AttributeNamesConstants.RUNTIME_VISIBLE_ANNOTATIONS) ? new RuntimeVisibleAnnotationsAttribute(classFileBytes, constantPool, offset + readOffset) : (Arrays.equals(attributeName, AttributeNamesConstants.RUNTIME_INVISIBLE_ANNOTATIONS) ? new RuntimeInvisibleAnnotationsAttribute(classFileBytes, constantPool, offset + readOffset) : (Arrays.equals(attributeName, AttributeNamesConstants.RUNTIME_VISIBLE_PARAMETER_ANNOTATIONS) ? new RuntimeVisibleParameterAnnotationsAttribute(classFileBytes, constantPool, offset + readOffset) : (Arrays.equals(attributeName, AttributeNamesConstants.RUNTIME_INVISIBLE_PARAMETER_ANNOTATIONS) ? new RuntimeInvisibleParameterAnnotationsAttribute(classFileBytes, constantPool, offset + readOffset) : (Arrays.equals(attributeName, AttributeNamesConstants.ANNOTATION_DEFAULT) ? new AnnotationDefaultAttribute(classFileBytes, constantPool, offset + readOffset) : new ClassFileAttribute(classFileBytes, constantPool, offset + readOffset))))));
            }
            readOffset = (int)((long)readOffset + (6L + this.u4At(classFileBytes, readOffset + 2, offset)));
            ++i;
        }
        this.attributeBytes = readOffset;
    }

    public int getAccessFlags() {
        return this.accessFlags;
    }

    public int getAttributeCount() {
        return this.attributesCount;
    }

    public ClassFileAttribute[] getAttributes() {
        return this.attributes;
    }

    public CodeAttribute getCodeAttribute() {
        return this.codeAttribute;
    }

    public char[] getDescriptor() {
        return this.descriptor;
    }

    public int getDescriptorIndex() {
        return this.descriptorIndex;
    }

    public ExceptionAttribute getExceptionAttribute() {
        return this.exceptionAttribute;
    }

    public char[] getName() {
        return this.name;
    }

    public int getNameIndex() {
        return this.nameIndex;
    }

    private boolean isAbstract() {
        return (this.accessFlags & 0x400) != 0;
    }

    public boolean isClinit() {
        return this.name[0] == '<' && this.name.length == 8;
    }

    public boolean isConstructor() {
        return this.name[0] == '<' && this.name.length == 6;
    }

    public boolean isDeprecated() {
        return this.isDeprecated;
    }

    private boolean isNative() {
        return (this.accessFlags & 0x100) != 0;
    }

    public boolean isSynthetic() {
        return this.isSynthetic;
    }

    int sizeInBytes() {
        return this.attributeBytes;
    }
}

