/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.fx.jface;

import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import org.eclipse.gef.fx.jface.FXPaintSelectionDialog;
import org.eclipse.gef.fx.jface.FXPaintUtils;
import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;

public class FXPaintCellEditor
extends DialogCellEditor {
    private Image image;

    public FXPaintCellEditor(Composite parent) {
        this(parent, 0);
    }

    public FXPaintCellEditor(Composite parent, int style) {
        super(parent, style);
        this.doSetValue(Color.TRANSPARENT);
    }

    protected ImageData createPaintImage(Control w, Paint paint) {
        int width = 64;
        int height = 16;
        if (w instanceof Table) {
            height = ((Table)w).getItemHeight() - 1;
        } else if (w instanceof Tree) {
            height = ((Tree)w).getItemHeight() - 1;
        }
        return FXPaintUtils.getPaintImageData(width, height, paint);
    }

    public void dispose() {
        if (this.image != null) {
            this.image.dispose();
            this.image = null;
        }
        super.dispose();
    }

    protected void doSetValue(Object value) {
        Object oldValue = this.getValue();
        if (oldValue == null ? value != null : !oldValue.equals(value)) {
            super.doSetValue(value);
        }
    }

    protected Object openDialogBox(Control cellEditorWindow) {
        int result;
        FXPaintSelectionDialog dialog = new FXPaintSelectionDialog(cellEditorWindow.getShell(), "Select Fill");
        Object value = this.getValue();
        if (value != null) {
            dialog.setPaint((Paint)value);
        }
        if ((result = dialog.open()) == 1) {
            return value;
        }
        return dialog.getPaint();
    }

    protected void updateContents(Object value) {
        Color paint;
        Label defaultLabel = this.getDefaultLabel();
        if (defaultLabel == null) {
            return;
        }
        Object object = paint = value == null ? Color.TRANSPARENT : (Paint)value;
        if (this.image != null) {
            this.image.dispose();
        }
        ImageData imageData = this.createPaintImage((Control)defaultLabel.getParent().getParent(), (Paint)paint);
        this.image = new Image((Device)defaultLabel.getDisplay(), imageData, imageData.getTransparencyMask());
        defaultLabel.setImage(this.image);
        defaultLabel.setText(FXPaintUtils.getPaintDisplayText((Paint)paint));
    }
}

