/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.wst.validation.Friend;
import org.eclipse.wst.validation.IMutableValidator;
import org.eclipse.wst.validation.MessageSeveritySetting;
import org.eclipse.wst.validation.MutableProjectSettings;
import org.eclipse.wst.validation.Validator;
import org.eclipse.wst.validation.internal.ConfigurationManager;
import org.eclipse.wst.validation.internal.IValChangedListener;
import org.eclipse.wst.validation.internal.PreferencesWrapper;
import org.eclipse.wst.validation.internal.ProjectConfiguration;
import org.eclipse.wst.validation.internal.ValManager;
import org.eclipse.wst.validation.internal.ValPrefManagerGlobal;
import org.eclipse.wst.validation.internal.ValidatorMetaData;
import org.eclipse.wst.validation.internal.ValidatorMutable;
import org.eclipse.wst.validation.internal.model.ProjectPreferences;
import org.eclipse.wst.validation.internal.plugin.ValidationPlugin;
import org.osgi.service.prefs.BackingStoreException;

public final class ValPrefManagerProject {
    private final IProject _project;
    private static final List<IValChangedListener> _listeners = new LinkedList<IValChangedListener>();
    private List<Validator> _validators;

    public ValPrefManagerProject(IProject project) {
        assert (project != null);
        this._project = project;
    }

    public static void addListener(IValChangedListener listener) {
        if (_listeners.contains(listener)) {
            return;
        }
        _listeners.add(listener);
    }

    public static void removeListener(IValChangedListener listener) {
        _listeners.remove(listener);
    }

    private static void updateListeners(IProject project) {
        for (IValChangedListener cl : _listeners) {
            cl.validatorsForProjectChanged(project, true);
        }
    }

    public boolean hasProjectSpecificSettings() {
        PreferencesWrapper pref = this.getPreferences(null);
        return pref != null;
    }

    public List<Validator> getValidators(Map<String, Validator> baseValidators) throws BackingStoreException {
        List<Validator> vals = this._validators;
        if (vals == null) {
            this._validators = vals = this.loadValidators(baseValidators);
        }
        return vals;
    }

    private List<Validator> loadValidators(Map<String, Validator> baseValidators) throws BackingStoreException {
        LinkedList<Validator> list = new LinkedList<Validator>();
        PreferencesWrapper pref = this.getPreferences(null);
        if (pref.nodeExists("vals")) {
            PreferencesWrapper vals = pref.node("vals");
            String[] stringArray = vals.childrenNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                Validator base = baseValidators.get(id);
                Validator v = ValPrefManagerGlobal.loadValidator(id, vals, base);
                if (v != null) {
                    Validator.V2 v2 = v.asV2Validator();
                    if (v2 != null) {
                        v2.setLevel(Validator.Level.Project);
                    }
                    list.add(v);
                }
                ++n2;
            }
        }
        return list;
    }

    public boolean getOverride() {
        PreferencesWrapper pref = this.getPreferences(null);
        if (!pref.nodeExists()) {
            return false;
        }
        int version = pref.getInt("vf.version", 0);
        if (version == 0) {
            try {
                ProjectConfiguration pc = ConfigurationManager.getManager().getProjectConfiguration(this._project);
                return pc.getDoesProjectOverride();
            }
            catch (InvocationTargetException invocationTargetException) {}
        }
        return pref.getBoolean("override", false);
    }

    private ProjectPreferences migrateFromBeforeWTP30(IProject project, Map<String, Validator> baseValidators) {
        try {
            ProjectConfiguration pc = ConfigurationManager.getManager().getProjectConfiguration(project);
            List<Validator> list = this.migrateFromBeforeWTP30(baseValidators, pc);
            Validator[] vals = new Validator[list.size()];
            list.toArray(vals);
            return new ProjectPreferences(project, pc.getDoesProjectOverride(), pc.isDisableAllValidation(), vals);
        }
        catch (InvocationTargetException invocationTargetException) {
            return new ProjectPreferences(project);
        }
    }

    private List<Validator> migrateFromBeforeWTP30(Map<String, Validator> baseValidators, ProjectConfiguration pc) throws InvocationTargetException {
        Set<String> build = pc.getEnabledBuildlValidators();
        Set<String> manual = pc.getEnabledManualValidators();
        LinkedList<Validator> list = new LinkedList<Validator>();
        for (Validator v : baseValidators.values()) {
            boolean isManual;
            Validator.V2 v2 = v.asV2Validator();
            if (v2 == null) continue;
            boolean isBuild = build == null || build.contains(v2.getValidatorClassname());
            boolean bl = isManual = manual == null || manual.contains(v2.getValidatorClassname());
            if (v.isBuildValidation() == isBuild && v.isManualValidation() == isManual) continue;
            Validator.V2 copy = v2.copy().asV2Validator();
            copy.setBuildValidation(isBuild);
            copy.setManualValidation(isManual);
            copy.setLevel(Validator.Level.Project);
            Friend.setMigrated(copy, true);
            list.add(copy);
        }
        return list;
    }

    public ProjectPreferences loadProjectPreferences(IProject project, Map<String, Validator> baseValidators) throws BackingStoreException {
        PreferencesWrapper pref = this.getPreferences(null);
        if (pref == null) {
            return null;
        }
        int version = pref.getInt("vf.version", 0);
        if (version == 0) {
            return this.migrateFromBeforeWTP30(project, baseValidators);
        }
        if (version != 3) {
            ValPrefManagerGlobal.migrate(version, pref);
        }
        if (!pref.nodeExists("vals")) {
            return new ProjectPreferences(project, pref.getBoolean("override", false), pref.getBoolean("suspend", false), new Validator[0]);
        }
        PreferencesWrapper vp = pref.node("vals");
        LinkedList<Validator> list = new LinkedList<Validator>();
        String[] stringArray = vp.childrenNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            Validator base = baseValidators.get(id);
            Validator v = ValPrefManagerGlobal.loadValidator(id, vp, base);
            if (v != null) {
                Validator.V2 v2 = v.asV2Validator();
                if (v2 != null) {
                    v2.setLevel(Validator.Level.Project);
                }
                list.add(v);
            }
            ++n2;
        }
        Validator[] vals = new Validator[list.size()];
        list.toArray(vals);
        return new ProjectPreferences(project, pref.getBoolean("override", false), pref.getBoolean("suspend", false), vals);
    }

    private PreferencesWrapper getPreferences(Boolean persist) {
        return PreferencesWrapper.getPreferences(this._project, persist);
    }

    public void savePreferences(ProjectPreferences projectPreferences) {
        Validator[] validators = projectPreferences.getValidators();
        PreferencesWrapper pref = this.getPreferences(null);
        pref.putBoolean("suspend", projectPreferences.getSuspend());
        pref.putBoolean("override", projectPreferences.getOverride());
        pref.putInt("vf.version", 3);
        PreferencesWrapper vals = pref.node("vals");
        try {
            Validator v;
            Validator[] workspaceVals = ValManager.getDefault().getValidators();
            HashMap<String, Validator> base = new HashMap<String, Validator>(workspaceVals.length);
            Validator[] validatorArray = workspaceVals;
            int n = workspaceVals.length;
            int n2 = 0;
            while (n2 < n) {
                v = validatorArray[n2];
                base.put(v.getId(), v);
                ++n2;
            }
            validatorArray = validators;
            n = validators.length;
            n2 = 0;
            while (n2 < n) {
                v = validatorArray[n2];
                ValPrefManagerGlobal.save(v, vals, base);
                ++n2;
            }
            pref.flush();
            ProjectConfiguration pc = ConfigurationManager.getManager().getProjectConfiguration(projectPreferences.getProject());
            pc.setEnabledBuildValidators(this.getEnabledBuildValidators(validators));
            pc.setEnabledManualValidators(this.getEnabledManualValidators(validators));
            pc.passivate();
            pc.store();
            ValPrefManagerProject.updateListeners(this._project);
        }
        catch (Exception e) {
            ValidationPlugin.getPlugin().handleException(e);
        }
    }

    public void savePreferences(ProjectPreferences projectPreferences, ValidatorMutable[] validators) {
        PreferencesWrapper pref = this.getPreferences(null);
        pref.putBoolean("suspend", projectPreferences.getSuspend());
        pref.putBoolean("override", projectPreferences.getOverride());
        pref.putInt("vf.version", 3);
        try {
            this.savePreferences(validators, false, null);
            pref.flush();
            ValPrefManagerProject.updateListeners(this._project);
        }
        catch (Exception e) {
            ValidationPlugin.getPlugin().handleException(e);
        }
    }

    public void savePreferences(MutableProjectSettings settings, Boolean persist) {
        block3: {
            IProject project = settings.getProject();
            PreferencesWrapper pref = PreferencesWrapper.getPreferences(project, persist);
            pref.putBoolean("suspend", settings.getSuspend());
            pref.putBoolean("override", settings.getOverride());
            pref.putInt("vf.version", 3);
            IMutableValidator[] vms = settings.getValidators();
            ValidatorMutable[] validators = new ValidatorMutable[vms.length];
            int i = 0;
            while (i < vms.length) {
                validators[i] = (ValidatorMutable)vms[i];
                ++i;
            }
            try {
                this.savePreferences(validators, false, persist);
                pref.flush();
                ValPrefManagerProject.updateListeners(project);
            }
            catch (Exception e) {
                if (!project.isAccessible()) break block3;
                ValidationPlugin.getPlugin().handleException(e);
            }
        }
    }

    public void savePreferences(ValidatorMutable[] validators, boolean flush, Boolean persist) {
        PreferencesWrapper pref = this.getPreferences(persist);
        pref.putInt("vf.version", 3);
        PreferencesWrapper vals = pref.node("vals");
        try {
            Object v;
            Validator[] workspaceVals = ValManager.getDefault().getValidators();
            HashMap<String, Validator> base = new HashMap<String, Validator>(workspaceVals.length);
            Object[] objectArray = workspaceVals;
            int n = workspaceVals.length;
            int n2 = 0;
            while (n2 < n) {
                v = objectArray[n2];
                base.put(((Validator)v).getId(), (Validator)v);
                ++n2;
            }
            objectArray = validators;
            n = validators.length;
            n2 = 0;
            while (n2 < n) {
                v = objectArray[n2];
                ValPrefManagerGlobal.save((ValidatorMutable)v, vals, base);
                ++n2;
            }
            ProjectConfiguration pc = ConfigurationManager.getManager().getProjectConfiguration(this._project);
            pc.setEnabledBuildValidators(this.getEnabledBuildValidators(validators));
            pc.setEnabledManualValidators(this.getEnabledManualValidators(validators));
            pc.passivate();
            pc.store();
            if (flush) {
                pref.flush();
                ValPrefManagerProject.updateListeners(this._project);
            }
        }
        catch (Exception e) {
            ValidationPlugin.getPlugin().handleException(e);
        }
    }

    private Set<ValidatorMetaData> getEnabledBuildValidators(Validator[] validators) {
        HashSet<ValidatorMetaData> set = new HashSet<ValidatorMetaData>(50);
        Validator[] validatorArray = validators;
        int n = validators.length;
        int n2 = 0;
        while (n2 < n) {
            Validator.V1 v1;
            Validator v = validatorArray[n2];
            if (v.isBuildValidation() && (v1 = v.asV1Validator()) != null) {
                set.add(v1.getVmd());
            }
            ++n2;
        }
        return set;
    }

    private Set<ValidatorMetaData> getEnabledBuildValidators(ValidatorMutable[] validators) {
        HashSet<ValidatorMetaData> set = new HashSet<ValidatorMetaData>(50);
        ValidatorMutable[] validatorMutableArray = validators;
        int n = validators.length;
        int n2 = 0;
        while (n2 < n) {
            ValidatorMutable v = validatorMutableArray[n2];
            if (v.isBuildValidation() && v.isV1Validator()) {
                set.add(v.getVmd());
            }
            ++n2;
        }
        return set;
    }

    private Set<ValidatorMetaData> getEnabledManualValidators(Validator[] validators) {
        HashSet<ValidatorMetaData> set = new HashSet<ValidatorMetaData>(50);
        Validator[] validatorArray = validators;
        int n = validators.length;
        int n2 = 0;
        while (n2 < n) {
            Validator.V1 v1;
            Validator v = validatorArray[n2];
            if (v.isManualValidation() && (v1 = v.asV1Validator()) != null) {
                set.add(v1.getVmd());
            }
            ++n2;
        }
        return set;
    }

    private Set<ValidatorMetaData> getEnabledManualValidators(ValidatorMutable[] validators) {
        HashSet<ValidatorMetaData> set = new HashSet<ValidatorMetaData>(50);
        ValidatorMutable[] validatorMutableArray = validators;
        int n = validators.length;
        int n2 = 0;
        while (n2 < n) {
            ValidatorMutable v = validatorMutableArray[n2];
            if (v.isManualValidation() && v.isV1Validator()) {
                set.add(v.getVmd());
            }
            ++n2;
        }
        return set;
    }

    public void loadMessages(Validator validator, Map<String, MessageSeveritySetting> settings) {
        try {
            ValPrefManagerGlobal.loadMessageSettings(validator, settings, this.getPreferences(null));
        }
        catch (BackingStoreException e) {
            ValidationPlugin.getPlugin().handleException(e);
        }
    }
}

