/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core;

import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelStatus;
import org.eclipse.dltk.core.IRegion;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ITypeHierarchy;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.internal.core.ModelOperation;
import org.eclipse.dltk.internal.core.ModelStatus;
import org.eclipse.dltk.internal.core.hierarchy.RegionBasedTypeHierarchy;
import org.eclipse.dltk.internal.core.hierarchy.TypeHierarchy;

public class CreateTypeHierarchyOperation
extends ModelOperation {
    protected TypeHierarchy typeHierarchy;

    public CreateTypeHierarchyOperation(IRegion region, ISourceModule[] workingCopies, IType element, boolean computeSubtypes) {
        super(element);
        this.typeHierarchy = new RegionBasedTypeHierarchy(region, workingCopies, element, computeSubtypes);
    }

    public CreateTypeHierarchyOperation(IType element, ISourceModule[] workingCopies, IDLTKSearchScope scope, boolean computeSubtypes) {
        super(element);
        ISourceModule[] copies;
        if (workingCopies != null) {
            int length = workingCopies.length;
            copies = new ISourceModule[length];
            System.arraycopy(workingCopies, 0, copies, 0, length);
        } else {
            copies = null;
        }
        this.typeHierarchy = new TypeHierarchy(element, copies, scope, computeSubtypes);
    }

    public CreateTypeHierarchyOperation(IType element, ISourceModule[] workingCopies, IScriptProject project, boolean computeSubtypes) {
        super(element);
        ISourceModule[] copies;
        if (workingCopies != null) {
            int length = workingCopies.length;
            copies = new ISourceModule[length];
            System.arraycopy(workingCopies, 0, copies, 0, length);
        } else {
            copies = null;
        }
        this.typeHierarchy = new TypeHierarchy(element, copies, project, computeSubtypes);
    }

    @Override
    protected void executeOperation() throws ModelException {
        this.typeHierarchy.refresh(this);
    }

    public ITypeHierarchy getResult() {
        return this.typeHierarchy;
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public IModelStatus verify() {
        IModelElement elementToProcess = this.getElementToProcess();
        if (elementToProcess == null && !(this.typeHierarchy instanceof RegionBasedTypeHierarchy)) {
            return new ModelStatus(968);
        }
        if (elementToProcess != null && !elementToProcess.exists()) {
            return new ModelStatus(969, elementToProcess);
        }
        IScriptProject project = this.typeHierarchy.javaProject();
        if (project != null && !project.exists()) {
            return new ModelStatus(969, project);
        }
        return ModelStatus.VERIFIED_OK;
    }
}

