/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.utils;

import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.dltk.compiler.util.Util;

public class MultiArrayIterator<E>
implements Iterator<E> {
    private E[] current;
    private int next;
    private final E[][] arrays;
    private int nextArray;

    public MultiArrayIterator(E[] first, E[] second) {
        this.current = first;
        this.arrays = new Object[][]{second};
        this.advance();
    }

    public MultiArrayIterator(Collection<E[]> arrays) {
        this.arrays = (Object[][])arrays.toArray((T[])new Object[arrays.size()][]);
        if (this.arrays.length == 0) {
            this.current = Util.EMPTY_ARRAY;
        } else {
            this.current = this.arrays[0];
            this.nextArray = 1;
        }
        this.advance();
    }

    @Override
    public boolean hasNext() {
        return this.next < this.current.length;
    }

    @Override
    public E next() {
        E result;
        try {
            result = this.current[this.next++];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new NoSuchElementException();
        }
        this.advance();
        return result;
    }

    private void advance() {
        if (this.next == this.current.length) {
            while (this.nextArray < this.arrays.length) {
                this.current = this.arrays[this.nextArray++];
                if (this.current.length == 0) continue;
                this.next = 0;
                break;
            }
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

