/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.profile.ui.launcher;

import java.text.MessageFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.php.internal.core.Logger;
import org.eclipse.php.internal.debug.core.launching.PHPLaunchUtilities;
import org.eclipse.php.internal.debug.core.preferences.PHPexeItem;
import org.eclipse.php.internal.debug.core.preferences.PHPexes;
import org.eclipse.php.internal.debug.ui.wizards.PHPExeEditDialog;
import org.eclipse.php.profile.ui.launcher.AbstractPHPLaunchConfigurationProfilerTab;
import org.eclipse.php.profile.ui.launcher.Messages;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class PHPExeLaunchConfigurationProfilerTab
extends AbstractPHPLaunchConfigurationProfilerTab {
    @Override
    protected void handleConfigureProfiler() {
        PHPexeItem phpExe = this.getPHPExe();
        if (phpExe != null) {
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            NullProgressMonitor monitor = new NullProgressMonitor();
            PHPExeEditDialog dialog = new PHPExeEditDialog(shell, phpExe, PHPexes.getInstance().getAllItems(), "org.eclipse.php.debug.ui.fragments.debuggerCompositeFragment");
            if (dialog.open() == 1) {
                monitor.setCanceled(true);
                return;
            }
        }
    }

    @Override
    protected String getCurrentProfilerId() {
        PHPexeItem phpExe = this.getPHPExe();
        if (phpExe == null) {
            return "org.eclipse.php.debug.core.noneDebugger";
        }
        return phpExe.getDebuggerID();
    }

    @Override
    protected String getNoProfilerMessage() {
        return MessageFormat.format(Messages.PHPExeLaunchConfigurationProfilerTab_No_profiler_is_attached, this.getPHPExe() != null ? this.getPHPExe().getName() : Messages.PHPExeLaunchConfigurationProfilerTab_None);
    }

    @Override
    protected void updateProfileTest() {
        this.validateProfilerBtn.setVisible(false);
    }

    @Override
    protected void performProfileTest() {
    }

    private PHPexeItem getPHPExe() {
        PHPexeItem phpExe = null;
        try {
            phpExe = PHPLaunchUtilities.getPHPExe((ILaunchConfiguration)this.getConfiguration());
        }
        catch (CoreException e) {
            Logger.logException((Throwable)e);
        }
        return phpExe;
    }
}

