/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.ast.nodes;

import java.util.List;
import org.eclipse.php.core.ast.nodes.ASTNode;
import org.eclipse.php.core.ast.nodes.ChildListPropertyDescriptor;
import org.eclipse.php.core.ast.nodes.Scalar;
import org.eclipse.php.core.ast.nodes.Variable;
import org.eclipse.php.core.ast.visitor.AbstractVisitor;

public class ASTNodes {
    public static ASTNode getParent(ASTNode node, Class<?> parentClass) {
        if (node == null) {
            return null;
        }
        while ((node = node.getParent()) != null && !parentClass.isInstance(node)) {
        }
        return node;
    }

    public static ASTNode getParent(ASTNode node, int nodeType) {
        if (node == null) {
            return null;
        }
        while ((node = node.getParent()) != null && node.getType() != nodeType) {
        }
        return node;
    }

    public static boolean isControlStatement(ASTNode node) {
        assert (node != null);
        int type = node.getType();
        return type == 34 || type == 28 || type == 26 || type == 61 || type == 20;
    }

    public static String getScalars(ASTNode node) {
        final StringBuilder builder = new StringBuilder();
        node.accept(new AbstractVisitor(){

            @Override
            public boolean visit(Scalar scalar) {
                builder.append(scalar.getStringValue());
                return true;
            }
        });
        return builder.toString();
    }

    public static boolean isQuotedDollaredCurlied(Variable variable) {
        if (variable.isDollared() || variable.getParent() == null) {
            return false;
        }
        ASTNode enclosing = null;
        if (variable.getParent().getType() == 0) {
            enclosing = variable.getParent().getParent();
            enclosing = enclosing != null && enclosing.getType() == 49 ? enclosing.getParent() : null;
        } else if (variable.getParent().getType() == 49) {
            enclosing = variable.getParent().getParent();
        }
        if (enclosing == null) {
            return false;
        }
        return enclosing.getType() == 47 || enclosing.getType() == 5;
    }

    public static <T extends ASTNode> List<T> getChildListProperty(ASTNode node, ChildListPropertyDescriptor propertyDescriptor) {
        return (List)node.getStructuralProperty(propertyDescriptor);
    }
}

