/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.compiler.ast.nodes;

import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.utils.CorePrinter;
import org.eclipse.php.internal.core.compiler.ast.visitor.ASTPrintVisitor;

public class CastExpression
extends Expression {
    public static final int TYPE_INT = 0;
    public static final int TYPE_REAL = 1;
    public static final int TYPE_STRING = 2;
    public static final int TYPE_ARRAY = 3;
    public static final int TYPE_OBJECT = 4;
    public static final int TYPE_BOOL = 5;
    public static final int TYPE_UNSET = 6;
    private final Expression expr;
    private final int castType;

    public CastExpression(int start, int end, Expression expr, int castType) {
        super(start, end);
        assert (expr != null);
        this.expr = expr;
        this.castType = castType;
    }

    public void traverse(ASTVisitor visitor) throws Exception {
        if (visitor.visit((Expression)this)) {
            this.expr.traverse(visitor);
            visitor.endvisit((Expression)this);
        }
    }

    public static String getCastType(int type) {
        switch (type) {
            case 0: {
                return "int";
            }
            case 1: {
                return "real";
            }
            case 2: {
                return "string";
            }
            case 3: {
                return "array";
            }
            case 4: {
                return "object";
            }
            case 5: {
                return "bool";
            }
            case 6: {
                return "unset";
            }
        }
        throw new IllegalArgumentException();
    }

    public int getKind() {
        return 8;
    }

    public int getCastType() {
        return this.castType;
    }

    public Expression getExpr() {
        return this.expr;
    }

    public final void printNode(CorePrinter output) {
    }

    public String toString() {
        return ASTPrintVisitor.toXMLString((ASTNode)this);
    }
}

