/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.compiler.ast.nodes;

import java.util.Collections;
import java.util.List;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.references.TypeReference;
import org.eclipse.dltk.ast.references.VariableReference;
import org.eclipse.dltk.ast.statements.Block;
import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.dltk.utils.CorePrinter;
import org.eclipse.php.internal.core.compiler.ast.visitor.ASTPrintVisitor;

public class CatchClause
extends Statement {
    private final List<TypeReference> classNames;
    private final VariableReference variable;
    private final Block statement;

    public CatchClause(int start, int end, TypeReference className, VariableReference variable, Block statement) {
        super(start, end);
        assert (className != null && statement != null);
        this.classNames = Collections.singletonList(className);
        this.variable = variable;
        this.statement = statement;
    }

    public CatchClause(int start, int end, List<TypeReference> classNames, VariableReference variable, Block statement) {
        super(start, end);
        assert (classNames != null && !classNames.isEmpty() && statement != null);
        this.classNames = classNames;
        this.variable = variable;
        this.statement = statement;
    }

    public void traverse(ASTVisitor visitor) throws Exception {
        if (visitor.visit((Statement)this)) {
            for (TypeReference typeReference : this.classNames) {
                typeReference.traverse(visitor);
            }
            if (this.variable != null) {
                this.variable.traverse(visitor);
            }
            this.statement.traverse(visitor);
            visitor.endvisit((Statement)this);
        }
    }

    public int getKind() {
        return 9;
    }

    public List<TypeReference> getClassNames() {
        return this.classNames;
    }

    public Block getStatement() {
        return this.statement;
    }

    public VariableReference getVariable() {
        return this.variable;
    }

    public final void printNode(CorePrinter output) {
    }

    public String toString() {
        return ASTPrintVisitor.toXMLString((ASTNode)this);
    }
}

