/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.phar;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class PharPackage {
    private IPath stubLocation = new Path("");
    private String stubVersion;
    private String alias;
    private int exportType;
    private int compressType;
    private Object[] fElements;
    private IPath fPharLocation;
    private boolean fOverwrite;
    private String signature;
    private boolean fIncludeDirectoryEntries;
    private boolean stubGenerated = true;

    public boolean isUseSignature() {
        return true;
    }

    public void setStubGenerated(boolean stubGenerated) {
        this.stubGenerated = stubGenerated;
    }

    public IPath getStubLocation() {
        return this.stubLocation;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public void setStubLocation(IPath stubLocation) {
        this.stubLocation = stubLocation;
    }

    public void setPharLocation(IPath path) {
        this.fPharLocation = path;
    }

    public IPath getPharLocation() {
        return this.fPharLocation;
    }

    public IPath getAbsolutePharLocation() {
        if (!this.fPharLocation.isAbsolute()) {
            IFile file;
            IPath absolutePath;
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            if (this.fPharLocation.segmentCount() >= 2 && (absolutePath = (file = root.getFile(this.fPharLocation)).getLocation()) != null) {
                return absolutePath;
            }
            return root.getLocation().append(this.fPharLocation);
        }
        return this.fPharLocation;
    }

    public boolean isStubGenerated() {
        return this.stubGenerated;
    }

    public int getExportType() {
        return this.exportType;
    }

    public void setExportType(int exportType) {
        this.exportType = exportType;
    }

    public int getCompressType() {
        return this.compressType;
    }

    public void setCompressType(int compressType) {
        this.compressType = compressType;
    }

    public IFile getStubFile() {
        IPath path = this.getStubLocation();
        if (path != null && path.isValidPath(path.toString()) && path.segmentCount() >= 2) {
            return ResourcesPlugin.getWorkspace().getRoot().getFile(path);
        }
        return null;
    }

    public PharPackage() {
        this.setPharLocation((IPath)Path.EMPTY);
        this.setIncludeDirectoryEntries(false);
    }

    public boolean allowOverwrite() {
        return this.fOverwrite;
    }

    public void setOverwrite(boolean state) {
        this.fOverwrite = state;
    }

    public void setStubVersion(String stubVersion) {
        this.stubVersion = stubVersion;
    }

    public String getStubVersion() {
        if (this.stubVersion == null) {
            return "1.1.0";
        }
        return this.stubVersion;
    }

    public Object[] getElements() {
        if (this.fElements == null) {
            this.setElements(new Object[0]);
        }
        return this.fElements;
    }

    public void setElements(Object[] elements) {
        this.fElements = elements;
    }

    public IFile[] findClassfilesFor(IFile javaFile) throws CoreException {
        return null;
    }

    public boolean isValid() {
        return this.getElements() != null && this.getElements().length > 0 && this.getAbsolutePharLocation() != null && this.isStubAccessible();
    }

    public boolean isStubAccessible() {
        if (this.isStubGenerated()) {
            return true;
        }
        IFile file = this.getStubFile();
        return file != null && file.isAccessible();
    }

    public boolean areDirectoryEntriesIncluded() {
        return this.fIncludeDirectoryEntries;
    }

    public void setIncludeDirectoryEntries(boolean includeDirectoryEntries) {
        this.fIncludeDirectoryEntries = includeDirectoryEntries;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public String getSignature() {
        return this.signature;
    }
}

