/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.search;

import org.eclipse.php.core.ast.nodes.ASTNode;
import org.eclipse.php.core.ast.nodes.BreakStatement;
import org.eclipse.php.core.ast.nodes.ContinueStatement;
import org.eclipse.php.core.ast.nodes.Expression;
import org.eclipse.php.core.ast.nodes.Program;
import org.eclipse.php.core.ast.nodes.Scalar;
import org.eclipse.php.core.ast.nodes.Statement;
import org.eclipse.php.internal.core.CoreMessages;
import org.eclipse.php.internal.core.Logger;
import org.eclipse.php.internal.core.search.AbstractOccurrencesFinder;
import org.eclipse.php.internal.core.search.IOccurrencesFinder;
import org.eclipse.php.internal.core.search.Messages;

public class BreakContinueTargetFinder
extends AbstractOccurrencesFinder {
    private static final String TARGET_OF = CoreMessages.getString("BreakContinueTargetFinder.0");
    public static final String ID = "BreakContinueTargetFinder";
    private static final int[] TARGETS = new int[]{28, 61, 56, 26, 20};
    private static final int[] STOPPERS = new int[]{46, 29};
    private Statement statement;
    private int nestingLevel;

    @Override
    public String initialize(Program root, ASTNode node) {
        this.fASTRoot = root;
        this.nestingLevel = 0;
        if (node != null) {
            if (node.getType() == 7) {
                BreakStatement bStatement = (BreakStatement)node;
                this.nestingLevel = this.getNestingLevel(bStatement.getExpression());
                this.statement = bStatement;
                return null;
            }
            if (node.getType() == 18) {
                ContinueStatement cStatement = (ContinueStatement)node;
                this.nestingLevel = this.getNestingLevel(cStatement.getExpression());
                this.statement = cStatement;
                return null;
            }
        }
        this.fDescription = "BreakContinueTargetFinder_occurrence_description";
        return this.fDescription;
    }

    protected final int getNestingLevel(Expression expression) {
        if (expression == null) {
            return 1;
        }
        if (expression.getType() == 51) {
            Scalar scalar = (Scalar)expression;
            try {
                return scalar.getScalarType() == 0 ? Integer.parseInt(scalar.getStringValue()) : 0;
            }
            catch (NumberFormatException e) {
                Logger.logException(e);
            }
        }
        return 0;
    }

    private boolean isTarget(int nodeType) {
        int[] nArray = TARGETS;
        int n = TARGETS.length;
        int n2 = 0;
        while (n2 < n) {
            int target = nArray[n2];
            if (target == nodeType) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean isStopper(int nodeType) {
        return nodeType == STOPPERS[0] || nodeType == STOPPERS[1];
    }

    @Override
    protected void findOccurrences() {
        if (this.nestingLevel == 0) {
            return;
        }
        Object nestingStr = "";
        if (this.nestingLevel > 1) {
            nestingStr = " " + Integer.toString(this.nestingLevel);
        }
        this.fDescription = Messages.format(TARGET_OF, this.statement.getType() == 7 ? "break" + (String)nestingStr : "continue" + (String)nestingStr);
        this.addOccurrences();
    }

    private void addOccurrences() {
        boolean targetFound = false;
        int nestingCount = 0;
        int blockEnd = -1;
        ASTNode parent = this.statement.getParent();
        while (!targetFound) {
            int type = parent.getType();
            if (this.isStopper(type)) break;
            if (this.isTarget(type)) {
                if (++nestingCount == this.nestingLevel) {
                    this.fResult.add(new IOccurrencesFinder.OccurrenceLocation(parent.getStart(), this.getLength(parent), this.getOccurrenceType(null), this.fDescription));
                    if (blockEnd > -1) {
                        this.fResult.add(new IOccurrencesFinder.OccurrenceLocation(blockEnd - 1, 1, this.getOccurrenceType(null), this.fDescription));
                    }
                    targetFound = true;
                } else {
                    blockEnd = -1;
                }
            } else {
                blockEnd = type == 6 ? parent.getEnd() : -1;
            }
            parent = parent.getParent();
        }
    }

    private int getLength(ASTNode parent) {
        switch (parent.getType()) {
            case 28: {
                return 3;
            }
            case 61: {
                return 5;
            }
            case 56: {
                return 6;
            }
            case 26: {
                return 7;
            }
            case 20: {
                return 2;
            }
        }
        return 0;
    }

    @Override
    protected int getOccurrenceType(ASTNode node) {
        return 7;
    }

    @Override
    public Program getASTRoot() {
        return this.fASTRoot;
    }

    @Override
    public String getElementName() {
        return null;
    }

    @Override
    public String getID() {
        return ID;
    }

    @Override
    public String getJobLabel() {
        return "BreakContinueTargetFinder_job_label";
    }

    @Override
    public int getSearchKind() {
        return 9;
    }

    @Override
    public String getUnformattedPluralLabel() {
        return "BreakContinueTargetFinder_label_plural";
    }

    @Override
    public String getUnformattedSingularLabel() {
        return "BreakContinueTargetFinder_label_singular";
    }
}

