/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.core.externalization;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.DayDateRange;
import org.eclipse.mylyn.internal.tasks.core.ITransferList;
import org.eclipse.mylyn.internal.tasks.core.LocalTask;
import org.eclipse.mylyn.internal.tasks.core.RepositoryModel;
import org.eclipse.mylyn.internal.tasks.core.RepositoryTaskHandleUtil;
import org.eclipse.mylyn.internal.tasks.core.TaskActivityUtil;
import org.eclipse.mylyn.internal.tasks.core.WeekDateRange;
import org.eclipse.mylyn.internal.tasks.core.externalization.SaxTaskListElementBuilder;
import org.eclipse.mylyn.internal.tasks.core.externalization.TaskListExternalizationConstants;
import org.eclipse.mylyn.tasks.core.IRepositoryManager;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.xml.sax.Attributes;

public class SaxTaskBuilder
extends SaxTaskListElementBuilder<AbstractTask> {
    private AbstractTask task;
    private final RepositoryModel repositoryModel;
    private final IRepositoryManager repositoryManager;

    public SaxTaskBuilder(RepositoryModel repositoryModel, IRepositoryManager repositoryManager) {
        this.repositoryModel = repositoryModel;
        this.repositoryManager = repositoryManager;
    }

    @Override
    public void beginItem(Attributes elementAttributes) {
        try {
            String handle = elementAttributes.getValue("Handle");
            String taskId = elementAttributes.getValue("TaskId");
            String repositoryUrl = elementAttributes.getValue("RepositoryUrl");
            String summary = StringUtils.defaultString((String)elementAttributes.getValue("Label"));
            String connectorKind = StringUtils.defaultString((String)elementAttributes.getValue("ConnectorKind"));
            if (handle != null) {
                if (taskId == null) {
                    taskId = RepositoryTaskHandleUtil.getTaskId(handle);
                }
                if (repositoryUrl == null) {
                    repositoryUrl = RepositoryTaskHandleUtil.getRepositoryUrl(handle);
                }
            } else {
                this.addError((IStatus)new Status(2, "org.eclipse.mylyn.tasks.core", "Task is missing handle attribute"));
                return;
            }
            this.task = this.createTask(connectorKind, repositoryUrl, taskId, summary);
            if (this.repositoryManager.getRepositoryConnector(this.task.getConnectorKind()) == null) {
                this.addError((IStatus)new Status(2, "org.eclipse.mylyn.tasks.core", String.format("Unable to read task, missing connector with kind \"%s\"", connectorKind)));
                return;
            }
            this.readTaskInfo(this.task, elementAttributes);
        }
        catch (Exception e) {
            this.addError((IStatus)new Status(2, "org.eclipse.mylyn.tasks.core", String.format("Exception reading task: %s", e.getMessage()), (Throwable)e));
        }
    }

    private AbstractTask createTask(String connectorKind, String repositoryUrl, String taskId, String summary) {
        AbstractTask task;
        if (repositoryUrl.equals("local")) {
            task = new LocalTask(taskId, summary);
        } else {
            TaskRepository taskRepository = this.repositoryModel.getTaskRepository(connectorKind, repositoryUrl);
            task = (AbstractTask)this.repositoryModel.createTask(taskRepository, taskId);
            task.setSummary(summary);
        }
        return task;
    }

    private void readTaskInfo(AbstractTask task, Attributes elementAttributes) {
        String key;
        String ownerId;
        String owner;
        String markReadPending;
        String reminded;
        String dueDate;
        String modificationDate;
        String creationDate;
        String priority = elementAttributes.getValue("Priority");
        if (priority != null) {
            task.setPriority(priority);
        } else {
            task.setPriority(TaskListExternalizationConstants.DEFAULT_PRIORITY);
        }
        String kind = elementAttributes.getValue("Kind");
        if (kind != null) {
            task.setTaskKind(kind);
        }
        String active = elementAttributes.getValue("Active");
        task.setActive(Boolean.parseBoolean(active));
        String url = elementAttributes.getValue("IssueURL");
        task.setUrl(StringUtils.defaultString((String)url));
        String notes = elementAttributes.getValue("Notes");
        task.setNotes(StringUtils.defaultString((String)notes));
        String estimationString = elementAttributes.getValue("Estimated");
        if (estimationString != null) {
            try {
                int estimate = Integer.parseInt(estimationString);
                task.setEstimatedTimeHours(estimate);
            }
            catch (Exception e) {
                task.setEstimatedTimeHours(0);
            }
        } else {
            task.setEstimatedTimeHours(0);
        }
        String completionDate = elementAttributes.getValue("EndDate");
        if (completionDate != null) {
            task.setCompletionDate(this.getDateFromString(completionDate));
        }
        if ((creationDate = elementAttributes.getValue("CreationDate")) != null) {
            task.setCreationDate(this.getDateFromString(creationDate));
        }
        if ((modificationDate = elementAttributes.getValue("ModificationDate")) != null) {
            task.setModificationDate(this.getDateFromString(modificationDate));
        }
        if ((dueDate = elementAttributes.getValue("DueDate")) != null) {
            task.setDueDate(this.getDateFromString(dueDate));
        }
        String scheduledStart = elementAttributes.getValue("ScheduledStartDate");
        String scheduledEnd = elementAttributes.getValue("ScheduledEndDate");
        if (scheduledStart != null && scheduledEnd != null) {
            Date startDate = this.getDateFromString(scheduledStart);
            Date endDate = this.getDateFromString(scheduledEnd);
            if (startDate != null && endDate != null && startDate.compareTo(endDate) <= 0) {
                Calendar calStart = TaskActivityUtil.getCalendar();
                calStart.setTime(startDate);
                Calendar calEnd = TaskActivityUtil.getCalendar();
                calEnd.setTime(endDate);
                if (DayDateRange.isDayRange(calStart, calEnd)) {
                    task.setScheduledForDate(new DayDateRange(calStart, calEnd));
                } else if (WeekDateRange.isWeekRange(calStart, calEnd)) {
                    task.setScheduledForDate(new WeekDateRange(calStart, calEnd));
                } else {
                    task.setScheduledForDate(TaskActivityUtil.getDayOf(new Date()));
                }
            }
        }
        if ((reminded = elementAttributes.getValue("Reminded")) != null) {
            task.setReminded(Boolean.parseBoolean(reminded));
        }
        if ((markReadPending = elementAttributes.getValue("MarkReadPending")) != null) {
            task.setMarkReadPending(Boolean.parseBoolean(markReadPending));
        }
        if ((owner = elementAttributes.getValue("Owner")) != null) {
            task.setOwner(owner);
        }
        if ((ownerId = elementAttributes.getValue("OwnerId")) != null) {
            task.setOwnerId(ownerId);
        }
        String notified = elementAttributes.getValue("NotifiedIncoming");
        task.setNotified(Boolean.parseBoolean(notified));
        String syncStateString = elementAttributes.getValue("offlineSyncState");
        if (syncStateString != null) {
            try {
                ITask.SynchronizationState state = ITask.SynchronizationState.valueOf(syncStateString);
                task.setSynchronizationState(state);
            }
            catch (IllegalArgumentException e) {
                this.addError((IStatus)new Status(0, "org.eclipse.mylyn.tasks.core", String.format("Invalid synchronization state \"%s\"", syncStateString)));
            }
        }
        if ((key = elementAttributes.getValue("Key")) != null) {
            task.setTaskKey(key);
        }
        task.setSynchronizing(false);
    }

    private Date getDateFromString(String dateString) {
        Date date = null;
        if (StringUtils.isEmpty((CharSequence)dateString)) {
            return null;
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S z", Locale.ENGLISH);
        try {
            date = format.parse(dateString);
        }
        catch (ParseException e) {
            this.addError((IStatus)new Status(0, "org.eclipse.mylyn.tasks.core", String.format("Could not parse date \"%s\"", dateString), (Throwable)e));
        }
        return date;
    }

    @Override
    protected void applyAttribute(String attributeKey, String attributeValue) {
        this.getItem().setAttribute(attributeKey, attributeValue);
    }

    @Override
    public AbstractTask getItem() {
        return this.task;
    }

    @Override
    public void addToTaskList(ITransferList taskList) {
        taskList.addTask(this.task);
    }
}

