/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.commons.ui.dialogs;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.mylyn.commons.ui.dialogs.IInPlaceDialogListener;
import org.eclipse.mylyn.commons.ui.dialogs.InPlaceDialogEvent;
import org.eclipse.mylyn.internal.commons.ui.Messages;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;

public abstract class AbstractInPlaceDialog
extends PopupDialog {
    public static final int ID_CLEAR = 1025;
    protected static final int MARGIN_SIZE = 3;
    private final int side;
    private final Rectangle controlBounds;
    private Control control;
    private final Set<IInPlaceDialogListener> listeners = new HashSet<IInPlaceDialogListener>();
    private final Control openControl;
    DisposeListener disposeListener = e -> this.dispose();

    public AbstractInPlaceDialog(Shell parent, int side, Control openControl) {
        super(parent, 4, false, false, false, false, false, null, null);
        Rectangle bounds;
        this.side = side;
        this.openControl = openControl;
        if (openControl == null || openControl.isDisposed()) {
            bounds = new Rectangle(0, 0, 0, 0);
        } else {
            bounds = openControl.getBounds();
            Point absPosition = openControl.toDisplay(openControl.getLocation());
            bounds.x = absPosition.x - bounds.x;
            bounds.y = absPosition.y - bounds.y;
        }
        this.controlBounds = bounds;
        if (openControl != null) {
            openControl.addDisposeListener(this.disposeListener);
        }
    }

    protected Control createContents(Composite parent) {
        return this.createDialogArea(parent);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gl = new GridLayout();
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        gl.horizontalSpacing = 0;
        gl.verticalSpacing = 0;
        gl.numColumns = 1;
        composite.setLayout((Layout)gl);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
        this.control = this.createControl(composite);
        Composite buttonComposite = new Composite(parent, 0);
        gl = new GridLayout();
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        gl.marginBottom = 3;
        gl.marginRight = 3;
        gl.horizontalSpacing = 10;
        gl.verticalSpacing = 0;
        gl.numColumns = 1;
        gl.makeColumnsEqualWidth = false;
        buttonComposite.setLayout((Layout)gl);
        GridDataFactory.fillDefaults().grab(true, false).align(0x1000008, 0x1000000).applyTo((Control)buttonComposite);
        this.createButtons(buttonComposite);
        Dialog.applyDialogFont((Control)parent);
        parent.pack();
        return parent;
    }

    protected abstract Control createControl(Composite var1);

    protected void createButtons(Composite composite) {
        this.createButton(composite, 1025, Messages.DateSelectionDialog_Clear, true);
    }

    protected void dispose() {
        this.setReturnCode(1);
        this.close();
    }

    protected Control createButton(Composite composite, final int returnCode, String text, final boolean shouldClose) {
        Button button = new Button(composite, 0);
        button.setText(text);
        button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AbstractInPlaceDialog.this.setReturnCode(returnCode);
                if (shouldClose) {
                    AbstractInPlaceDialog.this.close();
                } else {
                    AbstractInPlaceDialog.this.notifyButtonPressed(false);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        if (composite.getLayout() instanceof GridLayout) {
            ((GridLayout)composite.getLayout()).numColumns = composite.getChildren().length;
        }
        GridDataFactory.fillDefaults().applyTo((Control)button);
        return button;
    }

    public int open() {
        int result = super.open();
        this.getControl().setFocus();
        this.setReturnCode(-1);
        return result;
    }

    public boolean close() {
        if (this.getReturnCode() == -1) {
            this.setReturnCode(0);
        }
        this.notifyButtonPressed(true);
        if (this.openControl != null && !this.openControl.isDisposed()) {
            this.openControl.removeDisposeListener(this.disposeListener);
        }
        return super.close();
    }

    public void addEventListener(IInPlaceDialogListener listener) {
        this.listeners.add(listener);
    }

    public void removeCloseListener(IInPlaceDialogListener listener) {
        this.listeners.remove(listener);
    }

    private void notifyButtonPressed(boolean isClosing) {
        final InPlaceDialogEvent event = new InPlaceDialogEvent(this.getReturnCode(), isClosing);
        for (final IInPlaceDialogListener listener : this.listeners) {
            SafeRunnable.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    listener.buttonPressed(event);
                }

                public void handleException(Throwable exception) {
                }
            });
        }
    }

    protected void initializeBounds() {
        Rectangle monitorBounds = this.getShell().getMonitor().getClientArea();
        Rectangle bounds = this.getShell().getBounds();
        int x = 0;
        int y = 0;
        switch (this.side) {
            case 128: {
                x = this.controlBounds.x;
                y = this.controlBounds.y + this.controlBounds.height;
                if (x + bounds.width <= monitorBounds.x + monitorBounds.width) break;
                x = this.controlBounds.x + this.controlBounds.width - bounds.width;
                break;
            }
            case 1024: {
                x = this.controlBounds.x;
                y = this.controlBounds.y - bounds.height;
                if (x + bounds.width <= monitorBounds.x + monitorBounds.width) break;
                x = this.controlBounds.x + this.controlBounds.width - bounds.width;
                break;
            }
            case 131072: {
                x = this.controlBounds.x + this.controlBounds.width - bounds.width;
                y = this.controlBounds.y + this.controlBounds.height;
                break;
            }
            case 16384: {
                x = this.controlBounds.x;
                y = this.controlBounds.y + this.controlBounds.height;
            }
        }
        this.getShell().setBounds(x, y, bounds.width, bounds.height);
    }

    protected void adjustBounds() {
        Rectangle bounds;
        Point tipSize = this.getShell().getSize();
        Point location = this.getShell().getLocation();
        Point rightBounds = new Point(tipSize.x + location.x, tipSize.y + location.y);
        Monitor[] ms = this.getShell().getDisplay().getMonitors();
        if (ms.length > 1) {
            bounds = this.controlBounds;
            Point p = new Point(location.x, location.y);
            Monitor[] monitorArray = ms;
            int n = ms.length;
            int n2 = 0;
            while (n2 < n) {
                Monitor element = monitorArray[n2];
                Rectangle tmp = element.getBounds();
                if (tmp.contains(p)) {
                    bounds = tmp;
                    break;
                }
                ++n2;
            }
        } else {
            bounds = this.getControl().getDisplay().getBounds();
        }
        if (!bounds.contains(location) || !bounds.contains(rightBounds)) {
            if (rightBounds.x > bounds.x + bounds.width) {
                location.x -= rightBounds.x - (bounds.x + bounds.width);
            }
            if (rightBounds.y > bounds.y + bounds.height) {
                location.y -= rightBounds.y - (bounds.y + bounds.height);
            }
            if (location.x < bounds.x) {
                location.x = bounds.x;
            }
            if (location.y < bounds.y) {
                location.y = bounds.y;
            }
        }
        this.getShell().setLocation(location);
    }

    public Control getControl() {
        return this.control;
    }
}

