/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.componentcore.internal.impl;

import java.io.IOException;
import java.net.URL;
import org.eclipse.core.internal.boot.PlatformURLConnection;
import org.eclipse.core.internal.boot.PlatformURLHandler;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.StructureEdit;
import org.eclipse.wst.common.componentcore.internal.impl.ModuleURIUtil;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;

public class PlatformURLModuleConnection
extends PlatformURLConnection {
    public static final String MODULE = "module";
    public static final String MODULE_PROTOCOL = "module:";
    public static final String CLASSPATH = "classpath";
    public static final String RESOURCE_MODULE = "resource";
    public static final String BINARY_MODULE = "binary";

    public PlatformURLModuleConnection(URL aURL) {
        super(aURL);
    }

    public static URI resolve(URI aModuleResourceRuntimePath) throws IOException {
        try {
            IProject componentProject = StructureEdit.getContainingProject(aModuleResourceRuntimePath);
            URI runtimeURI = ModuleURIUtil.trimToDeployPathSegment(aModuleResourceRuntimePath);
            Path runtimePath = new Path(runtimeURI.path());
            IVirtualComponent component = ComponentCore.createComponent(componentProject);
            IVirtualFolder rootFolder = component.getRootFolder();
            int matchingSegs = runtimePath.matchingFirstSegments(rootFolder.getProjectRelativePath());
            if (matchingSegs > 0) {
                runtimePath = runtimePath.removeFirstSegments(matchingSegs);
            }
            IVirtualFile vFile = rootFolder.getFile((IPath)runtimePath);
            return URI.createPlatformResourceURI((String)vFile.getWorkspaceRelativePath().toString());
        }
        catch (Exception exception) {
            return aModuleResourceRuntimePath;
        }
    }

    protected URL resolve() throws IOException {
        System.out.println("URL: " + String.valueOf(this.getURL()));
        IPath resolvedPath = null;
        int count = resolvedPath.segmentCount();
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(resolvedPath.segment(0));
        if (!project.exists()) {
            String message = "Could not resolve URL";
            throw new IOException(message);
        }
        IPath result = null;
        if (count == 2) {
            result = project.getLocation();
        } else {
            resolvedPath = resolvedPath.removeFirstSegments(2);
            result = project.getFile(resolvedPath).getLocation();
        }
        return new URL("file", "", result.toString());
    }

    public static void startup() {
        PlatformURLHandler.register((String)MODULE, PlatformURLModuleConnection.class);
    }
}

