/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.core.internal.validate;

import java.util.List;
import java.util.Locale;
import org.eclipse.wst.html.core.internal.validate.CMUtil;
import org.eclipse.wst.html.core.internal.validate.ErrorInfoImpl;
import org.eclipse.wst.html.core.internal.validate.FMUtil;
import org.eclipse.wst.html.core.internal.validate.PrimeValidator;
import org.eclipse.wst.html.core.internal.validate.Segment;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.validate.ErrorInfo;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;
import org.eclipse.wst.xml.core.internal.modelquery.ModelQueryUtil;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMText;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class HTMLElementContentValidator
extends PrimeValidator {
    public boolean isAdapterForType(Object type) {
        return type == HTMLElementContentValidator.class || super.isAdapterForType(type);
    }

    public void validate(IndexedRegion node) {
        Element target = (Element)node;
        if (CMUtil.isForeign(target)) {
            return;
        }
        this.validateContent(target, target.getFirstChild());
    }

    private void validateContent(Element parent, Node child) {
        if (child == null) {
            return;
        }
        CMElementDeclaration ed = CMUtil.getDeclaration(parent);
        if (ed == null || ed.getContentType() == 0) {
            return;
        }
        List[] extendedContent = new List[1];
        while (child != null) {
            this.validateNode(parent, child, ed, extendedContent);
            child = child.getNextSibling();
        }
    }

    private void validateNode(Element target, Node child, CMElementDeclaration edec, List[] extendedContent) {
        Segment errorSeg;
        int contentType = 0;
        if (edec != null) {
            contentType = edec.getContentType();
        }
        int error = 0;
        int segType = 1;
        switch (child.getNodeType()) {
            case 1: {
                Element childElem = (Element)child;
                if (CMUtil.isForeign(childElem)) {
                    return;
                }
                CMElementDeclaration ced = CMUtil.getDeclaration((Element)child);
                if (ced == null || CMUtil.isSSI(ced) || !CMUtil.isHTML(ced)) {
                    return;
                }
                if (CMUtil.isObsolete((CMNode)ced)) {
                    error = 15;
                    break;
                }
                switch (contentType) {
                    case 0: {
                        return;
                    }
                    case 2: 
                    case 3: {
                        if (ced == null) {
                            return;
                        }
                        if (CMUtil.isValidChild(edec, ced)) {
                            return;
                        }
                        if (!CMUtil.isXHTML(edec) && CMUtil.isValidInclusion(ced, target)) {
                            return;
                        }
                        if (extendedContent[0] == null) {
                            extendedContent[0] = ModelQueryUtil.getModelQuery((Document)target.getOwnerDocument()).getAvailableContent(target, edec, 2);
                        }
                        List availableChildElementDeclarations = extendedContent[0];
                        int availableChildCount = availableChildElementDeclarations.size();
                        String elementName = ced.getElementName().toLowerCase(Locale.US);
                        int i = 0;
                        while (i < availableChildCount) {
                            CMNode cmnode = (CMNode)availableChildElementDeclarations.get(i);
                            if (cmnode.getNodeType() == 5 && cmnode.getNodeName().toLowerCase(Locale.US).equals(elementName)) {
                                return;
                            }
                            ++i;
                        }
                        error = 1001;
                        break;
                    }
                    default: {
                        error = 1001;
                    }
                }
                segType = 2;
                break;
            }
            case 3: {
                switch (contentType) {
                    case 0: 
                    case 3: 
                    case 4: 
                    case 5: {
                        return;
                    }
                    case 1: 
                    case 2: {
                        if (((IDOMText)child).isElementContentWhitespace()) {
                            return;
                        }
                        error = 1001;
                        break;
                    }
                    default: {
                        error = 1001;
                    }
                }
                segType = 1;
                break;
            }
            case 7: 
            case 8: {
                if (contentType != 1) {
                    return;
                }
                error = 1001;
                segType = 1;
                break;
            }
            case 4: {
                if (edec.supports("isXHTML") && Boolean.TRUE.equals(edec.getProperty("isXHTML"))) {
                    return;
                }
                if (!edec.getNodeName().equalsIgnoreCase("BODY")) {
                    switch (contentType) {
                        case 0: 
                        case 3: 
                        case 4: 
                        case 5: {
                            return;
                        }
                    }
                }
                error = 1001;
                segType = 1;
                break;
            }
            case 5: {
                break;
            }
            default: {
                error = 1001;
                segType = 1;
            }
        }
        if (error != 0 && (errorSeg = FMUtil.getSegment((IDOMNode)child, segType)) != null) {
            this.reporter.report((ErrorInfo)new ErrorInfoImpl(error, errorSeg, child));
        }
    }
}

