/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.terminal.view.ui.streams;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.terminal.connector.ITerminalControl;
import org.eclipse.terminal.view.ui.internal.Messages;
import org.eclipse.terminal.view.ui.internal.UIPlugin;
import org.eclipse.ui.services.IDisposable;

public class InputStreamMonitor
extends OutputStream
implements IDisposable {
    private final ITerminalControl terminalControl;
    private final OutputStream stream;
    private volatile Thread thread;
    private volatile boolean disposed;
    private final List<IDisposable> disposables = new ArrayList<IDisposable>();
    private final Queue<byte[]> queue = new LinkedList<byte[]>();
    private static final int TERMINAL_SENDS_CR = 0;
    private static final int TERMINAL_SENDS_CRLF = 1;
    private static final int PROGRAM_EXPECTS_LF = 0;
    private static final int PROGRAM_EXPECTS_CRLF = 1;
    private static final int PROGRAM_EXPECTS_CR = 2;
    private static final int NO_CHANGE = 0;
    private static final int CHANGE_CR_TO_LF = 1;
    private static final int INSERT_LF_AFTER_CR = 2;
    private static final int REMOVE_CR = 3;
    private static final int REMOVE_LF = 4;
    private static final int[][] CRLF_REPLACEMENT;
    private int replacement;
    private boolean disposalComing;

    static {
        int[][] nArrayArray = new int[2][];
        int[] nArray = new int[3];
        nArray[0] = 1;
        nArray[1] = 2;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[3];
        nArray2[0] = 3;
        nArray2[2] = 4;
        nArrayArray[1] = nArray2;
        CRLF_REPLACEMENT = nArrayArray;
    }

    public InputStreamMonitor(ITerminalControl terminalControl, OutputStream stream, boolean localEcho, String lineSeparator) {
        int terminalSends;
        Assert.isNotNull((Object)terminalControl);
        this.terminalControl = terminalControl;
        Assert.isNotNull((Object)stream);
        this.stream = stream;
        int n = terminalSends = localEcho ? 1 : 0;
        if (lineSeparator == null) {
            this.replacement = 0;
        } else {
            int programExpects = lineSeparator.equals("\\n") ? 0 : (lineSeparator.equals("\\r") ? 2 : 1);
            this.replacement = CRLF_REPLACEMENT[terminalSends][programExpects];
        }
    }

    protected final ITerminalControl getTerminalControl() {
        return this.terminalControl;
    }

    public final void addDisposable(IDisposable disposable) {
        Assert.isNotNull((Object)disposable);
        if (!this.disposed && !this.disposables.contains(disposable)) {
            this.disposables.add(disposable);
        }
    }

    public final void removeDisposable(IDisposable disposable) {
        Assert.isNotNull((Object)disposable);
        this.disposables.remove(disposable);
    }

    public void dispose() {
        if (this.disposed) {
            return;
        }
        this.disposalComing();
        this.disposed = true;
        try {
            this.stream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.close();
        for (IDisposable disposable : this.disposables) {
            disposable.dispose();
        }
        this.disposables.clear();
    }

    @Override
    public void close() {
        if (this.thread == null) {
            return;
        }
        Thread oldThread = this.thread;
        this.thread = null;
        oldThread.interrupt();
    }

    public void startMonitoring() {
        if (this.thread != null) {
            return;
        }
        Runnable runnable = () -> this.writeStream();
        this.thread = new Thread(runnable, "Terminal Input Stream Monitor Thread");
        this.thread.setDaemon(true);
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeStream() {
        block8: while (this.thread != null && !this.disposed) {
            byte[] data;
            Queue<byte[]> queue = this.queue;
            synchronized (queue) {
                while (this.queue.isEmpty()) {
                    if (this.disposed) {
                        break block8;
                    }
                    try {
                        this.queue.wait();
                    }
                    catch (InterruptedException e) {
                        break block8;
                    }
                }
                data = this.queue.poll();
            }
            if (data == null) continue;
            try {
                int written = 0;
                byte[] buf = new byte[1000];
                while (written < data.length) {
                    int len = Math.min(buf.length, data.length - written);
                    System.arraycopy(data, written, buf, 0, len);
                    this.stream.write(buf, 0, len);
                    this.stream.flush();
                    if ((written += len) >= data.length) continue;
                    Thread.sleep(100L);
                }
            }
            catch (IOException e) {
                if (this.disposed || this.disposalComing) continue;
                Status status = new Status(4, UIPlugin.getUniqueIdentifier(), NLS.bind((String)Messages.InputStreamMonitor_error_writingToStream, (Object)e.getLocalizedMessage()), (Throwable)e);
                UIPlugin.getDefault().getLog().log((IStatus)status);
            }
            catch (InterruptedException e) {
                break;
            }
        }
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(int b) throws IOException {
        Queue<byte[]> queue = this.queue;
        synchronized (queue) {
            this.queue.add(new byte[]{(byte)b});
            this.queue.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        Queue<byte[]> queue = this.queue;
        synchronized (queue) {
            byte[] processedBytes = this.onWriteContentToStream(b, off, len);
            if (processedBytes != b) {
                off = 0;
                len = processedBytes.length;
                b = processedBytes;
            }
            byte[] bytes = new byte[len];
            int j = 0;
            int i = 0;
            while (i < len) {
                bytes[j++] = b[off + i];
                ++i;
            }
            this.queue.add(bytes);
            this.queue.notifyAll();
        }
    }

    protected byte[] onWriteContentToStream(byte[] bytes, int off, int len) {
        Assert.isNotNull((Object)bytes);
        if (this.replacement != 0 && len > 0) {
            String origText = new String(bytes, off, len, this.terminalControl.getCharset());
            String text = null;
            if (this.replacement == 1) {
                text = origText.replace('\r', '\n');
            } else if (this.replacement == 2) {
                text = origText.replaceAll("\r\n|\r", "\r\n");
            } else if (this.replacement == 3) {
                text = origText.replaceAll("\\r", "");
            } else if (this.replacement == 4) {
                text = origText.replaceAll("\\n", "");
            }
            if (text != null && !origText.equals(text)) {
                bytes = text.getBytes(this.terminalControl.getCharset());
            }
        }
        return bytes;
    }

    public void disposalComing() {
        this.disposalComing = true;
    }
}

