/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.preferences.stepFilters;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.php.internal.core.util.FileUtils;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.php.internal.debug.core.preferences.stepFilters.DebugStepFilter;
import org.eclipse.php.internal.debug.core.preferences.stepFilters.DebugStepFilterEvent;
import org.eclipse.php.internal.debug.core.preferences.stepFilters.IDebugStepFilterPrefListener;
import org.eclipse.php.internal.ui.PHPUiPlugin;

public class DebugStepFilterController
implements IDebugStepFilterPrefListener {
    private static final int MAX_CACHE_SIZE = 5000;
    private static DebugStepFilterController instance = null;
    private DebugStepFilter[] enabledFilters = null;
    private DebugStepFilter[] extendedFilters = null;
    private HashMap<String, Boolean> filtersCheckCache = new HashMap();

    private DebugStepFilterController() {
    }

    public static synchronized DebugStepFilterController getInstance() {
        if (instance == null) {
            instance = new DebugStepFilterController();
        }
        return instance;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean isFiltered(String path) {
        Boolean cachedFilterResult = this.filtersCheckCache.get(path);
        if (cachedFilterResult != null) {
            return cachedFilterResult;
        }
        if (this.enabledFilters == null) {
            this.enabledFilters = this.getAllEnabledFilters();
        }
        boolean filterResult = false;
        DebugStepFilter[] debugStepFilterArray = this.enabledFilters;
        int n = this.enabledFilters.length;
        int n2 = 0;
        while (n2 < n) {
            block12: {
                DebugStepFilter currentFilter;
                block13: {
                    String filterPath;
                    block14: {
                        currentFilter = debugStepFilterArray[n2];
                        filterPath = currentFilter.getPath();
                        if (currentFilter.getType() != 9001) break block13;
                        if (!filterPath.startsWith("*") || !filterPath.endsWith("*")) break block14;
                        if (path.contains(filterPath.substring(1, filterPath.length() - 1))) {
                            filterResult = true;
                            break;
                        }
                        break block12;
                    }
                    if (filterPath.startsWith("*")) {
                        if (path.endsWith(filterPath.substring(1))) {
                            filterResult = true;
                            break;
                        }
                        break block12;
                    } else if (filterPath.endsWith("*")) {
                        if (path.startsWith(filterPath.substring(0, filterPath.length() - 1))) {
                            filterResult = true;
                            break;
                        }
                        break block12;
                    } else {
                        filterResult = FileUtils.checkIfEqualFilePaths((String)path, (String)currentFilter.getPath());
                        break;
                    }
                }
                if (currentFilter.getType() == 9002 || currentFilter.getType() == 9004 || currentFilter.getType() == 9009 || currentFilter.getType() == 9008) {
                    filterResult = FileUtils.checkIfContainerOfFile((String)currentFilter.getPath(), (String)path);
                    break;
                }
                if (currentFilter.getType() == 9005 || currentFilter.getType() == 9007) {
                    IPath resolvedVariablePath = DLTKCore.getResolvedVariablePath((IPath)new Path(currentFilter.getPath()));
                    if (resolvedVariablePath == null) break;
                    String includePathVarPath = resolvedVariablePath.toOSString();
                    filterResult = FileUtils.checkIfContainerOfFile((String)includePathVarPath, (String)path);
                    break;
                }
            }
            ++n2;
        }
        this.addToCache(path, filterResult);
        return filterResult;
    }

    private void addToCache(String path, boolean filterResult) {
        if (this.filtersCheckCache.size() > 5000) {
            this.filtersCheckCache.clear();
        }
        this.filtersCheckCache.put(path, filterResult);
    }

    private DebugStepFilter[] getAllEnabledFilters() {
        DebugStepFilter[] extendedFiltersList;
        IPreferenceStore store = PHPUiPlugin.getDefault().getPreferenceStore();
        String[] parsedFilters = this.parseList(store.getString("org.eclipse.php.debug.core.pref_step_filters_list"));
        ArrayList<DebugStepFilter> list = new ArrayList<DebugStepFilter>();
        int i = 0;
        while (i < parsedFilters.length) {
            String[] tokens = parsedFilters[i].split("\\?");
            if (tokens.length != 4) {
                return new DebugStepFilter[0];
            }
            DebugStepFilter tempFilter = new DebugStepFilter(Integer.parseInt(tokens[0]), Boolean.parseBoolean(tokens[1]), Boolean.parseBoolean(tokens[2]), tokens[3]);
            if (tempFilter.isEnabled()) {
                list.add(tempFilter);
            }
            ++i;
        }
        DebugStepFilter[] debugStepFilterArray = extendedFiltersList = this.getExtendedFiltersList();
        int n = extendedFiltersList.length;
        int n2 = 0;
        while (n2 < n) {
            DebugStepFilter filterExtended = debugStepFilterArray[n2];
            if (!list.contains(filterExtended)) {
                list.add(filterExtended);
            }
            ++n2;
        }
        DebugStepFilter[] result = new DebugStepFilter[list.size()];
        list.toArray(result);
        return result;
    }

    private String[] parseList(String listString) {
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(listString, "<>");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            list.add(token);
        }
        return list.toArray(new String[list.size()]);
    }

    @Override
    public void debugStepFilterModified(DebugStepFilterEvent event) {
        DebugStepFilter[] newFilters;
        this.filtersCheckCache.clear();
        ArrayList<DebugStepFilter> list = new ArrayList<DebugStepFilter>();
        DebugStepFilter[] debugStepFilterArray = newFilters = event.getNewFilters();
        int n = newFilters.length;
        int n2 = 0;
        while (n2 < n) {
            DebugStepFilter newFilter = debugStepFilterArray[n2];
            if (newFilter.isEnabled()) {
                list.add(newFilter);
            }
            ++n2;
        }
        this.enabledFilters = new DebugStepFilter[list.size()];
        list.toArray(this.enabledFilters);
    }

    private void readExtensionsList() {
        IConfigurationElement[] elements;
        ArrayList<DebugStepFilter> listToAdd = new ArrayList<DebugStepFilter>();
        String stepFilterExtensionName = "org.eclipse.php.debug.core.phpDebugStepFilters";
        IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor(stepFilterExtensionName);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (element.getName().equals("stepFilter")) {
                Boolean isEnabled = null;
                String path = null;
                int filterType = 0;
                try {
                    isEnabled = Boolean.parseBoolean(element.getAttribute("enabled"));
                    path = element.getAttribute("path");
                    filterType = this.getFilterTypeId(element.getAttribute("type"));
                }
                catch (InvalidRegistryObjectException ire) {
                    PHPDebugPlugin.log(ire);
                    return;
                }
                listToAdd.add(new DebugStepFilter(filterType, isEnabled, true, path));
            }
            ++n2;
        }
        this.extendedFilters = new DebugStepFilter[listToAdd.size()];
        listToAdd.toArray(this.extendedFilters);
    }

    private int getFilterTypeId(String attribute) {
        if (attribute.equals("PHP_PROJECT")) {
            return 9002;
        }
        if (attribute.equals("PHP_PROJECT_FILE")) {
            return 9003;
        }
        if (attribute.equals("PHP_PROJECT_FOLDER")) {
            return 9004;
        }
        if (attribute.equals("PATH_PATTERN")) {
            return 9001;
        }
        if (attribute.equals("PHP_INCLUDE_PATH_VAR")) {
            return 9005;
        }
        if (attribute.equals("PHP_INCLUDE_PATH_VAR_FILE")) {
            return 9006;
        }
        if (attribute.equals("PHP_INCLUDE_PATH_FOLDER")) {
            return 9007;
        }
        if (attribute.equals("PHP_INCLUDE_PATH_LIBRARY")) {
            return 9008;
        }
        if (attribute.equals("PHP_INCLUDE_PATH_LIBRARY_FILE")) {
            return 9010;
        }
        if (attribute.equals("PHP_INCLUDE_PATH_LIBRARY_FOLDER")) {
            return 9009;
        }
        return 0;
    }

    public DebugStepFilter[] getExtendedFiltersList() {
        if (this.extendedFilters == null) {
            this.readExtensionsList();
        }
        return this.extendedFilters;
    }
}

