/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.zend.debugger;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Map;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.php.internal.debug.core.PHPDebugCoreMessages;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.php.internal.debug.core.launching.PHPLaunchUtilities;
import org.eclipse.php.internal.debug.core.preferences.PHPexeItem;
import org.eclipse.php.internal.debug.core.preferences.PHPexes;
import org.eclipse.php.internal.debug.core.zend.debugger.ProcessCrashDetector;
import org.eclipse.php.internal.debug.daemon.DaemonPlugin;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class PHPExecutableDebuggerInitializer {
    protected ILaunch launch;

    public PHPExecutableDebuggerInitializer(ILaunch launch) throws IOException {
        this.launch = launch;
    }

    public void initializeDebug(String phpExe, String fileName, String workingDir, String query) {
        this.initializeDebug(phpExe, fileName, workingDir, query, null, null);
    }

    public void initializeDebug(String phpExe, String fileName, String workingDir, String query, Map<String, String> envVariables, String phpIniLocation) {
        try {
            try {
                Process p;
                PHPexeItem[] items;
                File phpExeFile = new File(phpExe);
                String phpConfigDir = phpExeFile.getParent();
                if (phpIniLocation != null && !phpIniLocation.equals("")) {
                    phpConfigDir = new File(phpIniLocation).getParent();
                }
                String sapiType = null;
                String phpV = null;
                PHPexeItem[] pHPexeItemArray = items = PHPexes.getInstance().getAllItems();
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    PHPexeItem item = pHPexeItemArray[n2];
                    if (item.getExecutable().equals(phpExeFile)) {
                        sapiType = item.getSapiType();
                        phpV = item.getVersion();
                        break;
                    }
                    ++n2;
                }
                String[] args = PHPLaunchUtilities.getProgramArguments(this.launch.getLaunchConfiguration());
                Map<String, String> additionalLaunchEnvironment = PHPLaunchUtilities.getPHPCGILaunchEnvironment(fileName, query, phpConfigDir, phpExeFile.getParent(), (String[])(sapiType == "CGI" ? args : null));
                if (envVariables == null) {
                    envVariables = additionalLaunchEnvironment;
                } else {
                    additionalLaunchEnvironment.putAll(envVariables);
                    envVariables = additionalLaunchEnvironment;
                }
                Object[] environmetVars = PHPLaunchUtilities.getEnvironment(this.launch.getLaunchConfiguration(), this.asAttributesArray(envVariables));
                Object[] phpCmdArray = PHPLaunchUtilities.getCommandLine(this.launch.getLaunchConfiguration(), phpExe, phpConfigDir, fileName, (String[])(sapiType == "CLI" ? args : null), phpV);
                PHPexes.changePermissions(new File(phpCmdArray[0]));
                if (PHPDebugPlugin.DEBUG) {
                    System.out.println("Executing: " + Arrays.toString(phpCmdArray));
                    System.out.println("Process environment: " + Arrays.toString(environmetVars));
                }
                DaemonPlugin.getDefault().makeSureDebuggerInitialized(null);
                File workingDirFile = new File(workingDir);
                if (workingDirFile.exists()) {
                    if (PHPDebugPlugin.DEBUG) {
                        System.out.println("Working directory: " + workingDir);
                    }
                    p = Runtime.getRuntime().exec((String[])phpCmdArray, (String[])environmetVars, workingDirFile);
                } else {
                    p = Runtime.getRuntime().exec((String[])phpCmdArray, (String[])environmetVars);
                }
                new Thread(new ProcessCrashDetector2(this.launch, p)).start();
            }
            catch (Exception e) {
                final Display display = Display.getDefault();
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        String message = e.getLocalizedMessage();
                        if (message != null) {
                            message = message.replaceFirst(e.getClass().getName() + ": ", "");
                            MessageDialog.openError((Shell)display.getActiveShell(), (String)PHPDebugCoreMessages.PHPExecutableDebuggerInitializer_6, (String)NLS.bind((String)PHPDebugCoreMessages.PHPExecutableDebuggerInitializer_7, (Object)message));
                        }
                    }
                });
                DebugPlugin.log((Throwable)e);
                if (phpIniLocation != null) {
                    File phpIniFile = new File(phpIniLocation);
                    phpIniFile.deleteOnExit();
                    phpIniFile.getParentFile().deleteOnExit();
                }
            }
        }
        finally {
            if (phpIniLocation != null) {
                File phpIniFile = new File(phpIniLocation);
                phpIniFile.deleteOnExit();
                phpIniFile.getParentFile().deleteOnExit();
            }
        }
    }

    private String[] asAttributesArray(Map<String, String> attributesMap) {
        String[] attributes = new String[attributesMap.size()];
        int index = 0;
        for (Map.Entry<String, String> entry : attributesMap.entrySet()) {
            attributes[index++] = entry.getKey() + "=" + entry.getValue();
        }
        return attributes;
    }

    class ProcessCrashDetector2
    extends ProcessCrashDetector {
        private ILaunch launch;

        public ProcessCrashDetector2(ILaunch launch, Process p) {
            super(launch, p);
            this.launch = launch;
        }

        @Override
        public void run() {
            super.run();
            if (this.launch != null && this.launch.getDebugTarget() == null) {
                String launchName = this.launch.getLaunchConfiguration().getName();
                boolean isRunMode = "run".equals(this.launch.getLaunchMode());
                String msg = null;
                msg = isRunMode ? MessageFormat.format(PHPDebugCoreMessages.Debugger_Error_Message_3, launchName) : MessageFormat.format(PHPDebugCoreMessages.Debugger_Error_Message_2, launchName);
                final String message = msg;
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)PHPDebugCoreMessages.Debugger_Launch_Error, (String)message);
                        DebugPlugin.getDefault().getLaunchManager().removeLaunch(ProcessCrashDetector2.this.launch);
                    }
                });
            }
        }
    }
}

