/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.refactoring.core.changes;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.osgi.util.NLS;
import org.eclipse.php.refactoring.core.changes.Messages;

public class RenameConfigurationChange
extends Change {
    private IResource fResource;
    private IPath fDest;
    private IPath fSource;
    private String fName;
    private String fNewName;
    private Map<ILaunchConfiguration, Map<String, String>> fConfigurationChanges;

    public RenameConfigurationChange(IPath source, IPath dest, String resName, String newName) {
        this.fSource = source;
        this.fDest = dest;
        this.fName = resName;
        this.fNewName = newName;
        IPath resourcePath = source.append(resName);
        if (source.segmentCount() < 1) {
            this.fResource = ResourcesPlugin.getWorkspace().getRoot().getProject(resName);
        } else {
            this.fResource = ResourcesPlugin.getWorkspace().getRoot().getFile(resourcePath);
            if (!this.fResource.exists()) {
                this.fResource = ResourcesPlugin.getWorkspace().getRoot().getFolder(resourcePath);
            }
        }
    }

    public Object getModifiedElement() {
        return this.fResource;
    }

    public String getName() {
        return NLS.bind((String)Messages.RenameConfigurationChange_0, (Object)this.fResource.getName());
    }

    public void initializeValidationData(IProgressMonitor pm) {
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return new RefactoringStatus();
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        ILaunchConfiguration[] launchConfigurations;
        IPath dest = this.fDest.append(this.fNewName);
        this.fConfigurationChanges = new HashMap<ILaunchConfiguration, Map<String, String>>();
        ILaunchConfiguration[] iLaunchConfigurationArray = launchConfigurations = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations();
        int n = launchConfigurations.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchConfiguration launchConfiguration = iLaunchConfigurationArray[n2];
            Map attributes = launchConfiguration.getAttributes();
            HashMap<String, String> changes = new HashMap<String, String>();
            for (Map.Entry attribute : attributes.entrySet()) {
                String newValue;
                Object attributeValue = attribute.getValue();
                if (!(attributeValue instanceof String)) continue;
                String attributeString = (String)attributeValue;
                String attributeName = (String)attribute.getKey();
                Path attributeValuePath = new Path(attributeString);
                if (this.fResource.getFullPath().isPrefixOf((IPath)attributeValuePath)) {
                    newValue = this.fResource instanceof IContainer ? dest.append(attributeValuePath.removeFirstSegments(attributeValuePath.matchingFirstSegments(this.fResource.getFullPath()))).makeAbsolute().toString() : dest.makeAbsolute().toString();
                    changes.put(attributeName, newValue);
                }
                if (this.fResource.getLocation() == null || !this.fResource.getLocation().isPrefixOf((IPath)attributeValuePath)) continue;
                newValue = null;
                if (this.fResource instanceof IContainer) {
                    projectPath = this.fResource.getFullPath();
                    fileSystemPath = this.fResource.getLocation().removeLastSegments(projectPath.segmentCount());
                    newValue = fileSystemPath.append(dest).append(attributeValuePath.removeFirstSegments(attributeValuePath.matchingFirstSegments(this.fResource.getLocation()))).toString();
                } else {
                    projectPath = this.fResource.getFullPath();
                    fileSystemPath = this.fResource.getLocation().removeLastSegments(projectPath.segmentCount());
                    newValue = fileSystemPath.append(dest).toString();
                }
                changes.put(attributeName, newValue);
            }
            if (changes.size() > 0) {
                this.fConfigurationChanges.put(launchConfiguration, changes);
            }
            ++n2;
        }
        for (Map.Entry<ILaunchConfiguration, Map<String, String>> configurationChange : this.fConfigurationChanges.entrySet()) {
            ILaunchConfiguration configuration = configurationChange.getKey();
            ILaunchConfigurationWorkingCopy configurationCopy = configuration instanceof ILaunchConfigurationWorkingCopy ? (ILaunchConfigurationWorkingCopy)configuration : configuration.getWorkingCopy();
            for (Map.Entry<String, String> change : configurationChange.getValue().entrySet()) {
                configurationCopy.setAttribute(change.getKey(), change.getValue());
            }
            configurationCopy.doSave();
        }
        return new RenameConfigurationChange(this.fDest, this.fSource, this.fNewName, this.fName);
    }
}

