/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.preferences;

import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.php.internal.debug.core.preferences.PHPDebugCorePreferenceNames;
import org.eclipse.php.internal.debug.ui.PHPDebugUIMessages;
import org.eclipse.php.internal.ui.Logger;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.preferences.AbstractPHPPreferencePageBlock;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.osgi.service.prefs.BackingStoreException;

public class WorkbenchOptionsBlock
extends AbstractPHPPreferencePageBlock {
    private Button fOpenInBrowser;
    private Button fOpenDebugViews;
    private PreferencePage propertyPage;
    private RadioGroupFieldEditor fSwitchPerspField;
    private RadioGroupFieldEditor fAllowMultipleLnchField;

    public void setCompositeAddon(Composite parent) {
        Composite composite = this.addPageContents(parent);
        this.addWorkspacePreferenceSubsection(composite);
    }

    public void initializeValues(PreferencePage propertyPage) {
        this.propertyPage = propertyPage;
        IPreferencesService service = Platform.getPreferencesService();
        this.fOpenDebugViews.setSelection(service.getBoolean("org.eclipse.php.debug.core", PHPDebugCorePreferenceNames.OPEN_DEBUG_VIEWS, true, null));
        this.fOpenInBrowser.setSelection(service.getBoolean("org.eclipse.php.debug.core", PHPDebugCorePreferenceNames.OPEN_IN_BROWSER, true, null));
        this.fAllowMultipleLnchField.setPreferenceStore(PHPUiPlugin.getDefault().getPreferenceStore());
        this.fAllowMultipleLnchField.load();
        this.fSwitchPerspField.setPreferenceStore(PHPUiPlugin.getDefault().getPreferenceStore());
        this.fSwitchPerspField.load();
    }

    public boolean performOK(boolean isProjectSpecific) {
        this.savePreferences();
        return true;
    }

    public void performApply(boolean isProjectSpecific) {
        this.performOK(isProjectSpecific);
    }

    public boolean performCancel() {
        return true;
    }

    public void performDefaults() {
        IEclipsePreferences prefs = PHPDebugPlugin.getDefaultPreferences();
        this.fOpenInBrowser.setSelection(prefs.getBoolean(PHPDebugCorePreferenceNames.OPEN_IN_BROWSER, true));
        this.fOpenDebugViews.setSelection(prefs.getBoolean(PHPDebugCorePreferenceNames.OPEN_DEBUG_VIEWS, true));
        this.fAllowMultipleLnchField.setPreferenceStore(PHPUiPlugin.getDefault().getPreferenceStore());
        this.fAllowMultipleLnchField.loadDefault();
        this.fSwitchPerspField.setPreferenceStore(PHPUiPlugin.getDefault().getPreferenceStore());
        this.fSwitchPerspField.loadDefault();
    }

    private void addWorkspacePreferenceSubsection(Composite composite) {
        this.fAllowMultipleLnchField = new RadioGroupFieldEditor("allowMultipleLaunches", PHPDebugUIMessages.PHPLaunchingPreferencePage_multipleMessage, 3, (String[][])new String[][]{{PHPDebugUIMessages.PHPLaunchingPreferencePage_Always, "always"}, {PHPDebugUIMessages.PHPLaunchingPreferencePage_Never, "never"}, {PHPDebugUIMessages.PHPLaunchingPreferencePage_Prompt, "prompt"}}, composite, true);
        this.fSwitchPerspField = new RadioGroupFieldEditor("switchBackToPHPPerspective", PHPDebugUIMessages.PHPLaunchingPreferencePage_switchToPHPMessage, 3, (String[][])new String[][]{{PHPDebugUIMessages.PHPLaunchingPreferencePage_Always, "always"}, {PHPDebugUIMessages.PHPLaunchingPreferencePage_Never, "never"}, {PHPDebugUIMessages.PHPLaunchingPreferencePage_Prompt, "prompt"}}, composite, true);
        Group group = new Group(composite, 0);
        group.setText(PHPDebugUIMessages.WorkbenchOptionsBlock_workbench_options);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(1808));
        this.fOpenInBrowser = this.addCheckBox((Composite)group, PHPDebugUIMessages.PHPDebugPreferencePage_11, PHPDebugCorePreferenceNames.OPEN_IN_BROWSER, 0);
        this.fOpenDebugViews = this.addCheckBox((Composite)group, PHPDebugUIMessages.PHPDebugPreferencePage_7, PHPDebugCorePreferenceNames.OPEN_DEBUG_VIEWS, 0);
    }

    private void savePreferences() {
        IEclipsePreferences prefs = PHPDebugPlugin.getInstancePreferences();
        prefs.putBoolean(PHPDebugCorePreferenceNames.OPEN_IN_BROWSER, this.fOpenInBrowser.getSelection());
        prefs.putBoolean(PHPDebugCorePreferenceNames.OPEN_DEBUG_VIEWS, this.fOpenDebugViews.getSelection());
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            Logger.logException((Throwable)e);
        }
        this.fAllowMultipleLnchField.store();
        this.fSwitchPerspField.store();
    }
}

