/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.actions;

import org.eclipse.dltk.internal.ui.callhierarchy.ICallHierarchyViewPart;
import org.eclipse.dltk.internal.ui.typehierarchy.TypeHierarchyViewPart;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.php.internal.ui.actions.Messages;
import org.eclipse.php.internal.ui.actions.OpenCallHierarchyAction;
import org.eclipse.php.internal.ui.actions.OpenTypeHierarchyAction;
import org.eclipse.php.internal.ui.editor.PHPStructuredEditor;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.actions.ContributionItemFactory;
import org.eclipse.ui.dialogs.PropertyDialogAction;
import org.eclipse.ui.keys.IBindingService;
import org.eclipse.ui.part.Page;

public class OpenViewActionGroup
extends ActionGroup {
    private boolean fEditorIsOwner;
    private IWorkbenchSite fSite;
    private OpenTypeHierarchyAction fOpenTypeHierarchy;
    private OpenCallHierarchyAction fOpenCallHierarchy;
    private PropertyDialogAction fOpenPropertiesDialog;
    private boolean fIsTypeHiararchyViewerOwner;
    private boolean fIsCallHiararchyViewerOwner;
    private ISelectionProvider fSelectionProvider;
    private boolean fShowOpenPropertiesAction = true;
    private boolean fShowInAction = true;

    public OpenViewActionGroup(Page page) {
        this.createSiteActions((IWorkbenchSite)page.getSite());
    }

    public OpenViewActionGroup(IViewPart part) {
        this.createSiteActions((IWorkbenchSite)part.getSite());
        this.fIsTypeHiararchyViewerOwner = part instanceof TypeHierarchyViewPart;
        this.fIsCallHiararchyViewerOwner = part instanceof ICallHierarchyViewPart;
    }

    public OpenViewActionGroup(PHPStructuredEditor part) {
        this.fEditorIsOwner = true;
        this.fOpenTypeHierarchy = new OpenTypeHierarchyAction(part);
        this.fOpenTypeHierarchy.setActionDefinitionId("org.eclipse.php.ui.edit.text.php.open.type.hierarchy");
        part.setAction("OpenTypeHierarchy", (IAction)this.fOpenTypeHierarchy);
        this.fOpenCallHierarchy = new OpenCallHierarchyAction(part);
        this.fOpenCallHierarchy.setActionDefinitionId("org.eclipse.php.ui.edit.text.php.open.call.hierarchy");
        part.setAction("OpenCallHierarchy", (IAction)this.fOpenCallHierarchy);
        this.initialize((IWorkbenchSite)part.getEditorSite());
    }

    private void createSiteActions(IWorkbenchSite site) {
        this.fOpenPropertiesDialog = new PropertyDialogAction((IShellProvider)site, site.getSelectionProvider());
        this.fOpenPropertiesDialog.setActionDefinitionId("org.eclipse.ui.file.properties");
        this.fOpenTypeHierarchy = new OpenTypeHierarchyAction(site);
        this.fOpenTypeHierarchy.setActionDefinitionId("org.eclipse.php.ui.edit.text.php.open.type.hierarchy");
        this.fOpenCallHierarchy = new OpenCallHierarchyAction(site);
        this.fOpenCallHierarchy.setActionDefinitionId("org.eclipse.php.ui.edit.text.php.open.call.hierarchy");
        this.initialize(site);
    }

    private void initialize(IWorkbenchSite site) {
        this.fSite = site;
        this.fSelectionProvider = this.fSite.getSelectionProvider();
        ISelection selection = this.fSelectionProvider.getSelection();
        this.fOpenTypeHierarchy.update(selection);
        this.fOpenCallHierarchy.update(selection);
        if (!this.fEditorIsOwner) {
            if (selection instanceof IStructuredSelection) {
                IStructuredSelection ss = (IStructuredSelection)selection;
                this.fOpenPropertiesDialog.selectionChanged(ss);
            } else {
                this.fOpenPropertiesDialog.selectionChanged(selection);
            }
            this.fSelectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.fOpenTypeHierarchy);
            this.fSelectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.fOpenCallHierarchy);
        }
    }

    public void fillActionBars(IActionBars actionBar) {
        super.fillActionBars(actionBar);
        this.setGlobalActionHandlers(actionBar);
    }

    public void fillContextMenu(IMenuManager menu) {
        super.fillContextMenu(menu);
        if (!this.fIsTypeHiararchyViewerOwner) {
            this.appendToGroup(menu, (IAction)this.fOpenTypeHierarchy);
        }
        if (!this.fIsCallHiararchyViewerOwner) {
            this.appendToGroup(menu, (IAction)this.fOpenCallHierarchy);
        }
        IStructuredSelection selection = this.getStructuredSelection();
        if (this.fShowOpenPropertiesAction && this.fOpenPropertiesDialog != null && this.fOpenPropertiesDialog.isEnabled() && selection != null && this.fOpenPropertiesDialog.isApplicableForSelection(selection)) {
            menu.appendToGroup("group.properties", (IAction)this.fOpenPropertiesDialog);
        }
        if (this.fShowInAction) {
            MenuManager showInSubMenu = new MenuManager(this.getShowInMenuLabel());
            IWorkbenchWindow workbenchWindow = this.fSite.getWorkbenchWindow();
            showInSubMenu.add(ContributionItemFactory.VIEWS_SHOW_IN.create(workbenchWindow));
            menu.appendToGroup("group.open", (IContributionItem)showInSubMenu);
        }
    }

    public void dispose() {
        this.fSelectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.fOpenTypeHierarchy);
        this.fSelectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.fOpenCallHierarchy);
        super.dispose();
    }

    private void setGlobalActionHandlers(IActionBars actionBars) {
        actionBars.setGlobalActionHandler("org.eclipse.php.ui.actions.OpenTypeHierarchy", (IAction)this.fOpenTypeHierarchy);
        actionBars.setGlobalActionHandler("org.eclipse.php.ui.actions.OpenCallHierarchy", (IAction)this.fOpenCallHierarchy);
        if (!this.fEditorIsOwner) {
            actionBars.setGlobalActionHandler(ActionFactory.PROPERTIES.getId(), (IAction)this.fOpenPropertiesDialog);
        }
    }

    private void appendToGroup(IMenuManager menu, IAction action) {
        if (action.isEnabled()) {
            menu.appendToGroup("group.open", action);
        }
    }

    private IStructuredSelection getStructuredSelection() {
        if (this.getContext() == null) {
            return null;
        }
        ISelection selection = this.getContext().getSelection();
        if (selection instanceof IStructuredSelection) {
            return (IStructuredSelection)selection;
        }
        return null;
    }

    private String getShowInMenuLabel() {
        String keyBinding = null;
        IBindingService bindingService = (IBindingService)PlatformUI.getWorkbench().getAdapter(IBindingService.class);
        if (bindingService != null) {
            keyBinding = bindingService.getBestActiveBindingFormattedFor("org.eclipse.ui.navigate.showInQuickMenu");
        }
        if (keyBinding == null) {
            keyBinding = "";
        }
        return Messages.OpenViewActionGroup_ShowInLabel + "\t" + keyBinding;
    }

    public void containsOpenPropertiesAction(boolean enable) {
        this.fShowOpenPropertiesAction = enable;
    }

    public void containsShowInAction(boolean enable) {
        this.fShowInAction = enable;
    }
}

