/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.actions;

import java.util.HashMap;
import java.util.ResourceBundle;
import org.eclipse.dltk.core.ICodeAssist;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.internal.ui.actions.ActionMessages;
import org.eclipse.dltk.internal.ui.actions.OpenActionUtil;
import org.eclipse.dltk.internal.ui.editor.EditorUtility;
import org.eclipse.dltk.internal.ui.text.ScriptWordFinder;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.IUpdate;
import org.eclipse.ui.texteditor.TextEditorAction;
import org.eclipse.wst.xml.core.internal.Logger;

public abstract class PHPEditorResolvingAction
extends TextEditorAction
implements IUpdate {
    public PHPEditorResolvingAction(ResourceBundle bundle, String prefix, ITextEditor editor) {
        super(bundle, prefix, editor);
        this.setEnabled(true);
    }

    public void run() {
        IModelElement[] modelElement = this.getSelectedElement();
        IModelElement selected = null;
        if (modelElement != null) {
            if (modelElement.length > 1) {
                IModelElement[] filteredElements = this.filterElements(modelElement);
                selected = OpenActionUtil.selectModelElement((IModelElement[])filteredElements, (Shell)this.getTextEditor().getSite().getShell(), (String)ActionMessages.OpenAction_error_title, (String)ActionMessages.OpenAction_select_element);
                if (selected == null) {
                    return;
                }
            } else {
                selected = modelElement[0];
            }
            this.doRun(selected);
        }
    }

    protected abstract void doRun(IModelElement var1);

    protected boolean isValid(IModelElement modelElement) {
        return modelElement != null;
    }

    public void update() {
        this.setEnabled(this.getTextEditor() != null);
    }

    protected IModelElement[] getSelectedElement() {
        IRegion wordRegion;
        ISourceModule input;
        block7: {
            block6: {
                ITextEditor editor = this.getTextEditor();
                ITextSelection textSelection = (ITextSelection)editor.getSelectionProvider().getSelection();
                int offset = textSelection.getOffset();
                input = EditorUtility.getEditorInputModelElement((IEditorPart)editor, (boolean)false);
                if (input == null) {
                    return null;
                }
                IDocument document = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
                wordRegion = ScriptWordFinder.findWord((IDocument)document, (int)offset);
                if (wordRegion != null) break block6;
                return null;
            }
            if (wordRegion.getOffset() >= 0 && wordRegion.getLength() >= 0) break block7;
            return null;
        }
        try {
            IModelElement[] elements = null;
            elements = ((ICodeAssist)input).codeSelect(wordRegion.getOffset(), wordRegion.getLength());
            if (elements != null && elements.length > 0) {
                return elements;
            }
        }
        catch (Exception e) {
            Logger.logException((Throwable)e);
        }
        return null;
    }

    private IModelElement[] filterElements(IModelElement[] elements) {
        if (elements == null) {
            return null;
        }
        HashMap<IModelElement, IModelElement> uniqueElements = new HashMap<IModelElement, IModelElement>();
        int i = 0;
        while (i < elements.length) {
            IModelElement element = elements[i];
            IModelElement module = element.getAncestor(5);
            if (module != null && !uniqueElements.containsKey(module)) {
                uniqueElements.put(module, element);
            }
            ++i;
        }
        return uniqueElements.values().toArray(new IModelElement[uniqueElements.size()]);
    }
}

