/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.util;

import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.util.PHPManualSite;

public class PHPManualSiteDescriptor {
    private static final String PHP_MANUAL_SITES_EXTENSION_POINT = "org.eclipse.php.ui.phpManualSites";
    private static final String SITE_TAG = "site";
    private static final String ID_ATTRIBUTE = "id";
    private static final String URL_ATTRIBUTE = "url";
    private static final String LABEL_ATTRIBUTE = "label";
    private static final String DIRECTOR_ATTRIBUTE = "director";
    private static final String EXTENSION_ATTRIBUTE = "extension";
    public static final String DEFAULT_PHP_MANUAL_SITE = PHPUIMessages.PHPManualSiteDescriptor_URL;
    public static final String DEFAULT_PHP_MANUAL_EXTENSION = "php";
    public static final String DEFAULT_PHP_MANUAL_LABEL = "PHP.net";
    public static final String DEFAULT_PHP_MANUAL_DIRECTOR = "org.eclipse.php.ui.phpManualDirector";
    private IConfigurationElement fElement;

    public PHPManualSiteDescriptor(IConfigurationElement element) {
        Assert.isNotNull((Object)element);
        this.fElement = element;
    }

    public static PHPManualSiteDescriptor[] getContributedSites() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] elements = registry.getConfigurationElementsFor(PHP_MANUAL_SITES_EXTENSION_POINT);
        PHPManualSiteDescriptor[] manualDescs = PHPManualSiteDescriptor.createDescriptors(elements);
        PHPManualSiteDescriptor.initializeFromPreferences(manualDescs);
        return manualDescs;
    }

    public PHPManualSite createSite() {
        return new PHPManualSite(this.getURL(), this.getExtension());
    }

    public String getURL() {
        return this.fElement.getAttribute(URL_ATTRIBUTE);
    }

    public String getDirectorID() {
        String director = this.fElement.getAttribute(DIRECTOR_ATTRIBUTE);
        if (director == null) {
            director = DEFAULT_PHP_MANUAL_DIRECTOR;
        }
        return director;
    }

    public String getLabel() {
        return this.fElement.getAttribute(LABEL_ATTRIBUTE);
    }

    public String getExtension() {
        return this.fElement.getAttribute(EXTENSION_ATTRIBUTE);
    }

    public String getID() {
        return this.fElement.getAttribute(ID_ATTRIBUTE);
    }

    private static PHPManualSiteDescriptor[] createDescriptors(IConfigurationElement[] elements) {
        ArrayList<PHPManualSiteDescriptor> result = new ArrayList<PHPManualSiteDescriptor>(elements.length);
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            if (SITE_TAG.equals(element.getName())) {
                PHPManualSiteDescriptor desc = new PHPManualSiteDescriptor(element);
                result.add(desc);
            }
            ++i;
        }
        return result.toArray(new PHPManualSiteDescriptor[result.size()]);
    }

    private static void initializeFromPreferences(PHPManualSiteDescriptor[] manualDescs) {
    }
}

