/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.wizards.types;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.php.internal.core.util.FileUtils;
import org.eclipse.wst.sse.core.utils.StringUtils;

public class TextTemplate {
    private static final int flags = 40;
    public static final String NULL_VAR = "";
    protected static StructPatternHandler patternHandler;
    protected static String REGEXP_ELEMENT_PLACEHOLDER;
    protected static String REGEXP_ELEMENT_VALID;
    protected static String REGEXP_STRUCT;
    protected static String REGEXP_VAR;
    Map<String, String> vars;

    static {
        REGEXP_ELEMENT_PLACEHOLDER = "@";
        REGEXP_ELEMENT_VALID = "(\\w+)";
        REGEXP_STRUCT = "/\\*\\s*" + REGEXP_ELEMENT_PLACEHOLDER + ":\\s*\\*/(.*?)/\\*\\s*:" + REGEXP_ELEMENT_PLACEHOLDER + "\\s*\\*/";
        REGEXP_VAR = "#" + REGEXP_ELEMENT_PLACEHOLDER + "#";
        patternHandler = new StructPatternHandler(REGEXP_STRUCT, REGEXP_ELEMENT_PLACEHOLDER);
    }

    public static String extract(String text, String structName) {
        if (NULL_VAR.equals(text)) {
            return null;
        }
        if (!structName.matches(REGEXP_ELEMENT_VALID)) {
            return null;
        }
        patternHandler.setStructName(structName);
        Matcher matcher = patternHandler.getMatcher().reset(text);
        if (matcher.find()) {
            return matcher.group();
        }
        return null;
    }

    public String compile(String text) {
        if (NULL_VAR.equals(text)) {
            return NULL_VAR;
        }
        Matcher matcher = Pattern.compile(StringUtils.replace((String)REGEXP_VAR, (String)REGEXP_ELEMENT_PLACEHOLDER, (String)REGEXP_ELEMENT_VALID)).matcher(text);
        while (matcher.find()) {
            String var = matcher.group(1);
            String val = this.vars.get(var);
            if (val == null) continue;
            String valCompiled = this.compile(val.toString());
            text = StringUtils.replace((String)text, (String)matcher.group(0), (String)valCompiled);
        }
        return text;
    }

    public String compile(String sourceVar, String targetVar, boolean append) {
        this.set(targetVar, (append ? this.get(targetVar) : NULL_VAR) + this.compile(this.get(sourceVar)));
        return this.get(targetVar);
    }

    Pattern createStructPattern(String structName) {
        return Pattern.compile(StringUtils.replace((String)REGEXP_STRUCT, (String)REGEXP_ELEMENT_PLACEHOLDER, (String)structName), 40);
    }

    public void extract(String sourceVar, String structName, String targetVar) {
        String struct;
        String text = this.get(sourceVar);
        if (text == null) {
            return;
        }
        if (targetVar == null) {
            targetVar = structName;
        }
        if ((struct = TextTemplate.extract(text, structName)) != null) {
            text = StringUtils.replace((String)text, (String)struct, (String)StringUtils.replace((String)REGEXP_VAR, (String)REGEXP_ELEMENT_PLACEHOLDER, (String)structName));
            this.vars.put(targetVar, patternHandler.getMatcher().group(1));
            this.vars.put(sourceVar, text);
        }
    }

    public String get(String var) {
        if (this.vars == null) {
            return NULL_VAR;
        }
        String val = this.vars.get(var);
        if (val == null) {
            return NULL_VAR;
        }
        return val.toString();
    }

    public String set(String var, String val) {
        if (this.vars == null) {
            this.vars = new HashMap<String, String>();
        }
        return this.vars.put(var, val);
    }

    public void setFile(String var, File file) throws IOException {
        this.set(var, FileUtils.getContents((File)file));
    }

    static class StructPatternHandler {
        protected Matcher matcher;
        protected Pattern pattern;
        protected String placeHolder;
        protected String regexp;
        protected String structName;

        public StructPatternHandler(String regexp, String placeHolder) {
            this.regexp = regexp;
            this.placeHolder = placeHolder;
        }

        public StructPatternHandler(String regexp, String placeHolder, String structName) {
            this(regexp, placeHolder);
            this.setStructName(structName);
        }

        public boolean equals(Object o) {
            if (o instanceof StructPatternHandler) {
                StructPatternHandler handler = (StructPatternHandler)o;
                return this.regexp.equals(handler.getRegexp()) && this.placeHolder.equals(handler.getPlaceHolder()) && (this.structName != null && this.structName.equals(handler.getStructName()) || this.structName == null && handler.getStructName() == null);
            }
            return false;
        }

        public Matcher getMatcher() {
            return this.matcher;
        }

        public String getPlaceHolder() {
            return this.placeHolder;
        }

        public String getRegexp() {
            return this.regexp;
        }

        public String getStructName() {
            return this.structName;
        }

        public void setStructName(String structName) {
            if (!structName.equals(this.structName)) {
                this.structName = structName;
                this.pattern = Pattern.compile(StringUtils.replace((String)REGEXP_STRUCT, (String)REGEXP_ELEMENT_PLACEHOLDER, (String)structName), 40);
                this.matcher = this.pattern.matcher(TextTemplate.NULL_VAR);
                this.matcher.reset();
            }
        }
    }
}

