/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.internal.ui.DLTKUIStatus;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.IThreadListener;

public class WorkbenchRunnableAdapter
implements IRunnableWithProgress,
IThreadListener {
    private boolean fTransfer = false;
    private IWorkspaceRunnable fWorkspaceRunnable;
    private ISchedulingRule fRule;

    public WorkbenchRunnableAdapter(IWorkspaceRunnable runnable) {
        this(runnable, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
    }

    public WorkbenchRunnableAdapter(IWorkspaceRunnable runnable, ISchedulingRule rule) {
        this.fWorkspaceRunnable = runnable;
        this.fRule = rule;
    }

    public WorkbenchRunnableAdapter(IWorkspaceRunnable runnable, ISchedulingRule rule, boolean transfer) {
        this.fWorkspaceRunnable = runnable;
        this.fRule = rule;
        this.fTransfer = transfer;
    }

    public ISchedulingRule getSchedulingRule() {
        return this.fRule;
    }

    public void threadChange(Thread thread) {
        if (this.fTransfer) {
            Job.getJobManager().transferRule(this.fRule, thread);
        }
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            DLTKCore.run((IWorkspaceRunnable)this.fWorkspaceRunnable, (ISchedulingRule)this.fRule, (IProgressMonitor)monitor);
        }
        catch (OperationCanceledException e) {
            throw new InterruptedException(e.getMessage());
        }
        catch (CoreException e) {
            throw new InvocationTargetException(e);
        }
    }

    public void runAsUserJob(String name, final Object jobFamiliy) {
        Job buildJob = new Job(name){

            /*
             * Loose catch block
             */
            protected IStatus run(IProgressMonitor monitor) {
                try {
                    try {
                        WorkbenchRunnableAdapter.this.run(monitor);
                    }
                    catch (InvocationTargetException e) {
                        Throwable cause = e.getCause();
                        if (cause instanceof CoreException) {
                            IStatus iStatus = ((CoreException)cause).getStatus();
                            monitor.done();
                            return iStatus;
                        }
                        IStatus iStatus = DLTKUIStatus.createError(4, cause);
                        monitor.done();
                        return iStatus;
                    }
                    catch (InterruptedException e) {
                        IStatus iStatus = Status.CANCEL_STATUS;
                        {
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                        monitor.done();
                        return iStatus;
                    }
                }
                finally {
                    monitor.done();
                }
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                return jobFamiliy == family;
            }
        };
        buildJob.setRule(this.fRule);
        buildJob.setUser(true);
        buildJob.schedule();
    }
}

