/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.terminal.view.ui.launcher;

import java.util.Map;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tm.terminal.view.ui.activator.UIPlugin;
import org.eclipse.tm.terminal.view.ui.interfaces.ILauncherDelegate;
import org.eclipse.tm.terminal.view.ui.nls.Messages;

public abstract class AbstractLauncherDelegate
extends PlatformObject
implements ILauncherDelegate {
    private String id = null;
    private String label = null;
    private Expression expression;
    private boolean hidden;

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        String value;
        IConfigurationElement[] children;
        if (config == null) {
            return;
        }
        this.id = config.getAttribute("id");
        if (this.id == null || "".equals(this.id.trim())) {
            throw this.createMissingMandatoryAttributeException("id", config.getContributor().getName());
        }
        this.label = config.getAttribute("label");
        if (this.label == null || "".equals(this.label.trim())) {
            this.label = config.getAttribute("name");
        }
        if ((children = config.getChildren()) != null && children.length > 0) {
            this.expression = ExpressionConverter.getDefault().perform(children[0]);
        }
        if ((value = config.getAttribute("hidden")) != null && !"".equals(value.trim())) {
            this.hidden = Boolean.parseBoolean(value);
        }
    }

    protected CoreException createMissingMandatoryAttributeException(String attributeName, String extensionId) {
        Assert.isNotNull((Object)attributeName);
        Assert.isNotNull((Object)extensionId);
        return new CoreException((IStatus)new Status(4, UIPlugin.getUniqueIdentifier(), 0, NLS.bind((String)Messages.Extension_error_missingRequiredAttribute, (Object)attributeName, (Object)extensionId), null));
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getLabel() {
        return this.label != null ? this.label.trim() : "";
    }

    @Override
    public Expression getEnablement() {
        return this.expression;
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    public boolean equals(Object obj) {
        if (obj instanceof AbstractLauncherDelegate) {
            return this.id.equals(((AbstractLauncherDelegate)obj).id);
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    protected String getDefaultTerminalTitle(Map<String, Object> properties) {
        String title = (String)properties.get("title");
        return title != null ? title : null;
    }
}

