/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.server.core.builtin;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.php.internal.debug.core.pathmapper.PathMapper;
import org.eclipse.php.internal.debug.core.preferences.PHPexeItem;
import org.eclipse.php.internal.server.core.builtin.FileUtil;
import org.eclipse.php.internal.server.core.builtin.IPHPServerConfiguration;
import org.eclipse.php.internal.server.core.builtin.IPHPServerConfigurationWorkingCopy;
import org.eclipse.php.internal.server.core.builtin.IPHPWebModule;
import org.eclipse.php.internal.server.core.builtin.Messages;
import org.eclipse.php.internal.server.core.builtin.PHPServer;
import org.eclipse.php.internal.server.core.builtin.PHPServerHelper;
import org.eclipse.php.internal.server.core.builtin.Trace;
import org.eclipse.php.internal.server.core.builtin.WebModule;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.ServerPort;

public abstract class PHPServerConfiguration
implements IPHPServerConfiguration,
IPHPServerConfigurationWorkingCopy {
    public static final String NAME_PROPERTY = "name";
    public static final String PORT_PROPERTY = "port";
    public static final String MODIFY_PORT_PROPERTY = "modifyPort";
    public static final String SERVER_XML_FILENAME = "server.xml";
    public static final String PHP_INI_FILENAME = "php.ini";
    protected IFolder configPath;
    private transient List<PropertyChangeListener> propertyListeners;

    public PHPServerConfiguration(IFolder path) {
        this.configPath = path;
    }

    protected IFolder getFolder() {
        return this.configPath;
    }

    protected IStatus backupAndPublish(IPath phpServerDir, boolean doBackup, IProgressMonitor monitor) {
        return Status.OK_STATUS;
    }

    protected void backupFolder(IFolder folder, IPath confDir, IPath backup, MultiStatus ms, IProgressMonitor monitor) throws CoreException {
        IResource[] children = folder.members();
        if (children == null) {
            return;
        }
        int size = children.length;
        monitor.beginTask(Messages.publishConfigurationTask, size * 100);
        int i = 0;
        while (i < size) {
            if (children[i] instanceof IFile) {
                try {
                    IFile file = (IFile)children[i];
                    String name = file.getName();
                    monitor.subTask(NLS.bind((String)Messages.publisherPublishTask, (Object[])new String[]{name}));
                    if (Trace.isTraceEnabled()) {
                        Trace.trace((byte)3, "Publishing " + name);
                    }
                    boolean copy = true;
                    if (backup != null && !backup.append(name).toFile().exists()) {
                        IStatus status = FileUtil.copyFile(confDir.append(name).toOSString(), String.valueOf(backup) + File.separator + name);
                        ms.add(status);
                        if (!status.isOK()) {
                            copy = false;
                        }
                    }
                    if (copy) {
                        InputStream fis;
                        String destPath = confDir.append(name).toOSString();
                        String destContents = null;
                        String srcContents = null;
                        File dest = new File(destPath);
                        if (dest.exists() && (destContents = PHPServerHelper.getFileContents(fis = new FileInputStream(destPath))) != null) {
                            fis = file.getContents();
                            srcContents = PHPServerHelper.getFileContents(fis);
                        }
                        if (destContents == null || srcContents == null || !srcContents.equals(destContents)) {
                            InputStream in = file.getContents();
                            ms.add(FileUtil.copyFile(in, destPath));
                        }
                    }
                }
                catch (Exception e) {
                    Trace.trace((byte)2, "backupAndPublish() error", e);
                    ms.add((IStatus)new Status(4, "org.eclipse.php.server.core", 0, NLS.bind((String)Messages.errorPublishConfiguration, (Object[])new String[]{e.getLocalizedMessage()}), (Throwable)e));
                }
            }
            monitor.worked(100);
            ++i;
        }
    }

    protected void backupPath(IPath path, IPath confDir, IPath backup, MultiStatus ms, IProgressMonitor monitor) {
        File[] files = path.toFile().listFiles();
        if (files == null) {
            return;
        }
        int size = files.length;
        monitor.beginTask(Messages.publishConfigurationTask, size * 100);
        int i = 0;
        while (i < size) {
            try {
                File file = files[i];
                String name = file.getName();
                monitor.subTask(NLS.bind((String)Messages.publisherPublishTask, (Object[])new String[]{name}));
                if (Trace.isTraceEnabled()) {
                    Trace.trace((byte)3, "Publishing " + name);
                }
                boolean copy = true;
                if (backup != null && !backup.append(name).toFile().exists()) {
                    IStatus status = FileUtil.copyFile(confDir.append(name).toOSString(), String.valueOf(backup) + File.separator + name);
                    ms.add(status);
                    if (!status.isOK()) {
                        copy = false;
                    }
                }
                if (copy) {
                    ms.add(FileUtil.copyFile(file.getAbsolutePath(), confDir.append(name).toOSString()));
                }
            }
            catch (Exception e) {
                Trace.trace((byte)2, "backupAndPublish() error", e);
                ms.add((IStatus)new Status(4, "org.eclipse.php.server.core", 0, NLS.bind((String)Messages.errorPublishConfiguration, (Object[])new String[]{e.getLocalizedMessage()}), (Throwable)e));
            }
            monitor.worked(100);
            ++i;
        }
    }

    protected IStatus publishContextConfig(IPath baseDir, IPath deployDir, IProgressMonitor monitor) {
        return Status.OK_STATUS;
    }

    protected IStatus updateContextsToServeDirectly(IPath baseDir, String phpVersion, String loader, IProgressMonitor monitor) {
        return Status.OK_STATUS;
    }

    protected IStatus cleanupServer(IPath confDir, IPath installDir, boolean removeKeptContextFiles, IProgressMonitor monitor) {
        return Status.OK_STATUS;
    }

    public abstract IStatus localizeConfiguration(IPath var1, IPath var2, PHPServer var3, IProgressMonitor var4);

    public abstract ServerPort getMainPort();

    public abstract PathMapper.Mapping[] getPathMappings(String var1);

    public abstract PathMapper.Mapping[] getPathMappings();

    public abstract void setPathMapping(String var1, PathMapper.Mapping[] var2);

    public String getDocBasePrefix() {
        return "";
    }

    protected String getWebModuleURL(IModule webModule) {
        WebModule module = this.getWebModule(webModule);
        if (module != null) {
            return module.getPath();
        }
        return null;
    }

    public WebModule getWebModule(IModule module) {
        if (module == null) {
            return null;
        }
        String memento = module.getId();
        List<WebModule> modules = this.getWebModules();
        int size = modules.size();
        int i = 0;
        while (i < size) {
            WebModule webModule = modules.get(i);
            if (memento.equals(webModule.getMemento())) {
                return webModule;
            }
            ++i;
        }
        return null;
    }

    protected abstract void save(IFolder var1, IProgressMonitor var2) throws CoreException;

    protected void firePropertyChangeEvent(String propertyName, Object oldValue, Object newValue) {
        if (this.propertyListeners == null) {
            return;
        }
        PropertyChangeEvent event = new PropertyChangeEvent(this, propertyName, oldValue, newValue);
        try {
            Iterator<PropertyChangeListener> iterator = this.propertyListeners.iterator();
            while (iterator.hasNext()) {
                try {
                    PropertyChangeListener listener = iterator.next();
                    listener.propertyChange(event);
                }
                catch (Exception e) {
                    Trace.trace((byte)2, "Error firing property change event", e);
                }
            }
        }
        catch (Exception e) {
            Trace.trace((byte)2, "Error in property event", e);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.propertyListeners == null) {
            this.propertyListeners = new ArrayList<PropertyChangeListener>();
        }
        this.propertyListeners.add(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.propertyListeners != null) {
            this.propertyListeners.remove(listener);
        }
    }

    public void importFromPath(IPath path, PHPexeItem phpExeItem, IProgressMonitor monitor) throws CoreException {
        this.load(path, phpExeItem, monitor);
    }

    protected abstract void load(IPath var1, PHPexeItem var2, IProgressMonitor var3) throws CoreException;

    protected abstract void load(IFolder var1, IProgressMonitor var2) throws CoreException;

    public abstract void addWebModule(int var1, IPHPWebModule var2);

    public abstract void removeWebModule(int var1);

    public abstract IPath getServerWorkDirectory(IPath var1);

    public abstract IPath getContextWorkDirectory(IPath var1, IModule var2);

    public String toString() {
        return "PHPServerConfiguration[" + String.valueOf(this.getFolder()) + "]";
    }
}

