/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.server.core.builtin;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.php.internal.server.core.builtin.PHPServer;
import org.eclipse.php.internal.server.core.builtin.PHPServerBehaviour;
import org.eclipse.php.internal.server.core.builtin.Trace;

public class PHPServerHelper {
    public static String getFileContents(InputStream stream) throws IOException {
        StringBuilder sb;
        block9: {
            BufferedReader br = null;
            sb = new StringBuilder();
            try {
                try {
                    br = new BufferedReader(new InputStreamReader(stream));
                    String temp = br.readLine();
                    while (temp != null) {
                        sb.append(temp).append("\n");
                        temp = br.readLine();
                    }
                }
                catch (Exception e) {
                    Trace.trace((byte)1, "Could not load file contents.", e);
                    if (br != null) {
                        br.close();
                    }
                    break block9;
                }
            }
            catch (Throwable throwable) {
                if (br != null) {
                    br.close();
                }
                throw throwable;
            }
            if (br != null) {
                br.close();
            }
        }
        return sb.toString();
    }

    public static IPath getStandardBaseDirectory(PHPServer ps) {
        String baseDir = ps.getDocumentRootDirectory();
        if (baseDir == null) {
            PHPServerBehaviour tsb = (PHPServerBehaviour)ps.getServer().loadAdapter(PHPServerBehaviour.class, null);
            return tsb.getTempDirectory();
        }
        Path path = new Path(baseDir);
        if (!path.isAbsolute()) {
            IPath rootPath = ResourcesPlugin.getWorkspace().getRoot().getLocation();
            path = rootPath.append((IPath)path);
        }
        return path;
    }

    public static IStatus createDeploymentDirectory(IPath deployDir) {
        File temp;
        if (Trace.isTraceEnabled()) {
            Trace.trace((byte)4, "Creating deployment directory at " + deployDir.toOSString());
        }
        if (!(temp = deployDir.toFile()).exists()) {
            temp.mkdirs();
        }
        return Status.OK_STATUS;
    }
}

