/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.server.core.builtin;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.php.internal.server.core.builtin.Messages;
import org.eclipse.php.internal.server.core.builtin.PHPServerBehaviour;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.model.IModuleResource;
import org.eclipse.wst.server.core.model.IModuleResourceDelta;
import org.eclipse.wst.server.core.model.PublishOperation;
import org.eclipse.wst.server.core.util.PublishHelper;

public class PublishOperation2
extends PublishOperation {
    protected PHPServerBehaviour server;
    protected IModule[] module;
    protected int kind;
    protected int deltaKind;
    private PublishHelper helper;

    public PublishOperation2(PHPServerBehaviour server, int kind, IModule[] module, int deltaKind) {
        super("Publish to server", "Publish PHP Web module to PHP built-in server");
        this.server = server;
        this.module = module;
        this.kind = kind;
        this.deltaKind = deltaKind;
        IPath base = server.getRuntimeBaseDirectory();
        this.helper = base != null ? new PublishHelper(base.append("temp").toFile()) : new PublishHelper(null);
    }

    public int getOrder() {
        return 0;
    }

    public int getKind() {
        return 2;
    }

    public void execute(IProgressMonitor monitor, IAdaptable info) throws CoreException {
        ArrayList<IStatus> status = new ArrayList<IStatus>();
        if (this.module.length == 1) {
            this.publishDir(this.module[0], status, monitor);
        }
        PublishOperation2.throwException(status);
        this.server.setModulePublishState2(this.module, 1);
    }

    private void publishDir(IModule module2, List<IStatus> status, IProgressMonitor monitor) throws CoreException {
        IStatus[] stat;
        IPath path = this.server.getModuleDeployDirectory(module2);
        if (this.kind == 4 || this.deltaKind == 3) {
            File f = path.toFile();
            if (f.exists()) {
                stat = PublishHelper.deleteDirectory((File)f, (IProgressMonitor)monitor);
                PublishOperation2.addArrayToList(status, stat);
            }
            if (this.deltaKind == 3) {
                return;
            }
        }
        if (this.kind == 4 || this.kind == 2) {
            IModuleResource[] mr = this.server.getResources(this.module);
            stat = this.helper.publishFull(mr, path, monitor);
            PublishOperation2.addArrayToList(status, stat);
            return;
        }
        IModuleResourceDelta[] delta = this.server.getPublishedResourceDelta(this.module);
        int size = delta.length;
        int i = 0;
        while (i < size) {
            IStatus[] stat2 = this.helper.publishDelta(delta[i], path, monitor);
            PublishOperation2.addArrayToList(status, stat2);
            ++i;
        }
    }

    protected static void throwException(List<IStatus> status) throws CoreException {
        if (status == null || status.size() == 0) {
            return;
        }
        if (status.size() == 1) {
            IStatus status2 = status.get(0);
            throw new CoreException(status2);
        }
        IStatus[] children = new IStatus[status.size()];
        status.toArray(children);
        String message = Messages.errorPublish;
        MultiStatus status2 = new MultiStatus("org.eclipse.php.server.core", 0, children, message, null);
        throw new CoreException((IStatus)status2);
    }

    protected static void addArrayToList(List<IStatus> list, IStatus[] a) {
        if (list == null || a == null || a.length == 0) {
            return;
        }
        int size = a.length;
        int i = 0;
        while (i < size) {
            list.add(a[i]);
            ++i;
        }
    }
}

