/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.server.core.builtin.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import org.eclipse.php.internal.server.core.builtin.Trace;
import org.eclipse.php.internal.server.core.builtin.xml.XMLElement;
import org.eclipse.php.internal.server.core.builtin.xml.XMLUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Factory {
    protected String packageName;
    protected Document document;

    protected Attr createAttribute(String s, Element element) {
        Attr attr = this.document.createAttribute(s);
        element.setAttributeNode(attr);
        return attr;
    }

    protected XMLElement createElement(int index, String s, Node node) {
        if (index < 0) {
            return this.createElement(s, node);
        }
        Element element = this.document.createElement(s);
        try {
            Node child = node.getFirstChild();
            while (child != null && !s.equals(child.getNodeName())) {
                child = child.getNextSibling();
            }
            int i = 0;
            while (child != null && i < index) {
                child = child.getNextSibling();
                while (child != null && !s.equals(child.getNodeName())) {
                    child = child.getNextSibling();
                }
                ++i;
            }
            if (child != null) {
                node.insertBefore(element, child);
            } else {
                node.appendChild(element);
            }
        }
        catch (Exception e) {
            node.appendChild(element);
        }
        return this.newInstance(element);
    }

    protected XMLElement createElement(String s, Node node) {
        Element element = this.document.createElement(s);
        node.appendChild(element);
        return this.newInstance(element);
    }

    public byte[] getContents() throws IOException {
        return XMLUtil.getContents(this.document);
    }

    public Document getDocument() {
        return this.document;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public XMLElement loadDocument(String content) throws IOException, SAXException {
        try {
            this.document = XMLUtil.getDocumentBuilder().parse(new InputSource(new StringReader(content)));
            Element element = this.document.getDocumentElement();
            return this.newInstance(element);
        }
        catch (IllegalArgumentException exception) {
            Trace.trace((byte)1, "Error loading document", exception);
            throw new IOException("Could not load document");
        }
    }

    public XMLElement loadDocument(InputStream in) throws IOException, SAXException {
        try {
            this.document = XMLUtil.getDocumentBuilder().parse(new InputSource(in));
            Element element = this.document.getDocumentElement();
            return this.newInstance(element);
        }
        catch (IllegalArgumentException exception) {
            Trace.trace((byte)1, "Error loading document", exception);
            throw new IOException("Could not load document");
        }
    }

    protected XMLElement newInstance(Element element) {
        Object s = element.getNodeName();
        try {
            s = ((String)s).substring(0, 1).toUpperCase() + ((String)s).substring(1);
            int i = ((String)s).indexOf("-");
            while (i >= 0) {
                s = ((String)s).substring(0, i) + ((String)s).substring(i + 1, i + 2).toUpperCase() + ((String)s).substring(i + 2);
                i = ((String)s).indexOf("-");
            }
            i = ((String)s).indexOf(":");
            while (i >= 0) {
                s = ((String)s).substring(0, i) + ((String)s).substring(i + 1, i + 2).toUpperCase() + ((String)s).substring(i + 2);
                i = ((String)s).indexOf(":");
            }
            if (this.packageName != null) {
                s = this.packageName + "." + (String)s;
            }
            Class<?> class1 = Class.forName((String)s);
            XMLElement xmlElement = (XMLElement)class1.newInstance();
            xmlElement.setElement(element);
            xmlElement.setFactory(this);
            return xmlElement;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void save(String filename) throws IOException {
        XMLUtil.save(filename, this.document);
    }

    public void setDocument(Document d) {
        this.document = d;
    }

    public void setPackageName(String s) {
        this.packageName = s;
    }
}

