/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.documentLink;

import java.net.URI;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServers;
import org.eclipse.lsp4j.DocumentLink;
import org.eclipse.lsp4j.DocumentLinkParams;

public class DocumentLinkDetector
extends AbstractHyperlinkDetector {
    public IHyperlink @Nullable [] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        IDocument document = textViewer.getDocument();
        if (document == null) {
            return null;
        }
        URI uri = LSPEclipseUtils.toUri(document);
        if (uri == null) {
            return null;
        }
        DocumentLinkParams params = new DocumentLinkParams(LSPEclipseUtils.toTextDocumentIdentifier(uri));
        try {
            return (IHyperlink[])((CompletableFuture)((LanguageServers.LanguageServerDocumentExecutor)LanguageServers.forDocument(document).withFilter(capabilities -> capabilities.getDocumentLinkProvider() != null)).collectAll(languageServer -> languageServer.getTextDocumentService().documentLink(params)).thenApply(links -> {
                IHyperlink[] res = (IHyperlink[])links.stream().flatMap(Collection::stream).filter(Objects::nonNull).filter(link -> link.getTarget() != null).map(link -> this.toHyperlink(region, document, (DocumentLink)link)).filter(Objects::nonNull).toArray(IHyperlink[]::new);
                if (res.length == 0) {
                    return null;
                }
                return res;
            })).get(4L, TimeUnit.SECONDS);
        }
        catch (ExecutionException e) {
            LanguageServerPlugin.logError(e);
            return null;
        }
        catch (InterruptedException e) {
            LanguageServerPlugin.logError(e);
            Thread.currentThread().interrupt();
            return null;
        }
        catch (TimeoutException e) {
            LanguageServerPlugin.logWarning("Could not detect hyperlinks due to timeout after 4 seconds");
            return null;
        }
    }

    private @Nullable DocumentHyperlink toHyperlink(IRegion region, IDocument document, DocumentLink link) {
        DocumentHyperlink jfaceLink = null;
        try {
            int start = LSPEclipseUtils.toOffset(link.getRange().getStart(), document);
            int end = LSPEclipseUtils.toOffset(link.getRange().getEnd(), document);
            Region linkRegion = new Region(start, end - start);
            if (TextUtilities.overlaps((IRegion)region, (IRegion)linkRegion)) {
                jfaceLink = new DocumentHyperlink(link.getTarget(), (IRegion)linkRegion);
            }
        }
        catch (BadLocationException ex) {
            LanguageServerPlugin.logError(ex);
        }
        return jfaceLink;
    }

    public static class DocumentHyperlink
    implements IHyperlink {
        private final String uri;
        private final IRegion highlightRegion;

        public DocumentHyperlink(String uri, IRegion highlightRegion) {
            this.uri = uri;
            this.highlightRegion = highlightRegion;
        }

        public IRegion getHyperlinkRegion() {
            return this.highlightRegion;
        }

        public String getTypeLabel() {
            return this.uri;
        }

        public String getHyperlinkText() {
            return this.uri;
        }

        public void open() {
            LSPEclipseUtils.open(this.uri, null, true);
        }
    }
}

