/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.lang.invoke.LambdaMetafactory;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.lucene.store.FlushInfo;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.MergeInfo;

record DefaultIOContext(Set<IOContext.FileOpenHint> hints) implements IOContext
{
    public DefaultIOContext(Set<IOContext.FileOpenHint> hints) {
        this.hints = Set.copyOf((Collection)Objects.requireNonNull(hints));
        Map<Class, List<IOContext.FileOpenHint>> hintClasses = hints.stream().collect(Collectors.groupingBy((Function<IOContext.FileOpenHint, Class>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getClass(), (Lorg/apache/lucene/store/IOContext$FileOpenHint;)Ljava/lang/Class;)()));
        for (Map.Entry<Class, List<IOContext.FileOpenHint>> hintType : hintClasses.entrySet()) {
            if (hintType.getValue().size() <= 1) continue;
            throw new IllegalArgumentException("Multiple hints of type " + String.valueOf(hintType) + " specified");
        }
    }

    public DefaultIOContext(IOContext.FileOpenHint ... hints) {
        this(Set.of(hints));
    }

    @Override
    public IOContext.Context context() {
        return IOContext.Context.DEFAULT;
    }

    @Override
    public MergeInfo mergeInfo() {
        return null;
    }

    @Override
    public FlushInfo flushInfo() {
        return null;
    }

    @Override
    public IOContext withHints(IOContext.FileOpenHint ... hints) {
        return new DefaultIOContext(hints);
    }
}

