/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.model.attribute;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum IntersectionType implements Enumerator
{
    MIN_LITERAL(0, "Min", "Min"),
    MAX_LITERAL(1, "Max", "Max"),
    VALUE_LITERAL(2, "Value", "Value");

    public static final int MIN = 0;
    public static final int MAX = 1;
    public static final int VALUE = 2;
    private static final IntersectionType[] VALUES_ARRAY;
    public static final List<IntersectionType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new IntersectionType[]{MIN_LITERAL, MAX_LITERAL, VALUE_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static IntersectionType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            IntersectionType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static IntersectionType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            IntersectionType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static IntersectionType get(int value) {
        switch (value) {
            case 0: {
                return MIN_LITERAL;
            }
            case 1: {
                return MAX_LITERAL;
            }
            case 2: {
                return VALUE_LITERAL;
            }
        }
        return null;
    }

    private IntersectionType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

