/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.trace.experiment;

import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;
import org.eclipse.tracecompass.tmf.core.trace.experiment.TmfExperiment;

@NonNullByDefault
public final class TmfExperimentUtils {
    private TmfExperimentUtils() {
    }

    private static Iterable<ITmfTrace> getTracesFromHost(TmfExperiment experiment, String hostId) {
        HashSet<ITmfTrace> hostTraces = new HashSet<ITmfTrace>();
        for (ITmfTrace trace : experiment.getTraces()) {
            if (!trace.getHostId().equals(hostId)) continue;
            hostTraces.add(trace);
        }
        return hostTraces;
    }

    public static @Nullable IAnalysisModule getAnalysisModuleForHost(TmfExperiment experiment, String hostId, String analysisId) {
        for (ITmfTrace trace : TmfExperimentUtils.getTracesFromHost(experiment, hostId)) {
            IAnalysisModule module = trace.getAnalysisModule(analysisId);
            if (module == null) continue;
            return module;
        }
        return null;
    }

    public static <T extends IAnalysisModule> @Nullable T getAnalysisModuleOfClassForHost(TmfExperiment experiment, String hostId, Class<T> moduleClass) {
        for (ITmfTrace trace : TmfExperimentUtils.getTracesFromHost(experiment, hostId)) {
            Iterator<T> iterator = TmfTraceUtils.getAnalysisModulesOfClass(trace, moduleClass).iterator();
            if (!iterator.hasNext()) continue;
            IAnalysisModule module = (IAnalysisModule)iterator.next();
            return (T)module;
        }
        return null;
    }
}

