/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.ctf.core.event.types;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.ctf.core.event.scope.IDefinitionScope;
import org.eclipse.tracecompass.ctf.core.event.types.EnumDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.IntegerDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.SimpleDatatypeDefinition;

public final class EnumDefinition
extends SimpleDatatypeDefinition {
    private static final String UNKNOWN_ENUM = "<unknown> (%s)";
    private final IntegerDefinition fInteger;
    private final @Nullable String fValue;

    public EnumDefinition(@NonNull EnumDeclaration declaration, IDefinitionScope definitionScope, @NonNull String fieldName, IntegerDefinition intValue) {
        super(declaration, definitionScope, fieldName);
        this.fInteger = intValue;
        this.fValue = declaration.query(this.fInteger.getValue());
    }

    public String getValue() {
        return this.fValue != null ? this.fValue : String.format(UNKNOWN_ENUM, this.getIntegerValue());
    }

    @Override
    public String getStringValue() {
        return this.getValue();
    }

    @Override
    public Long getIntegerValue() {
        return this.fInteger.getValue();
    }

    @Override
    public EnumDeclaration getDeclaration() {
        return (EnumDeclaration)super.getDeclaration();
    }

    @Override
    public long size() {
        return this.fInteger.size();
    }

    @Override
    public byte[] getBytes() {
        return this.fInteger.getBytes();
    }

    @Override
    public String toString() {
        return "{ value = " + this.getValue() + ", container = " + this.fInteger.getValue() + " }";
    }
}

