/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.jsoncdb.core.participant;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.regex.Matcher;
import org.eclipse.cdt.jsoncdb.core.participant.Arglets;
import org.eclipse.cdt.jsoncdb.core.participant.IParserHandler;
import org.eclipse.cdt.jsoncdb.core.participant.IResponseFileArglet;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class ResponseFileArglets {
    private static final String REGEX_QUOTED_FILE = "\\s*([\"'])(.+?)\\1";
    private static final String REGEX_UNQUOTED_FILE = "\\s*([^\\s]+)";

    public static class At
    implements IResponseFileArglet {
        private static final Arglets.NameOptionMatcher[] optionMatchers = new Arglets.NameOptionMatcher[]{new Arglets.NameOptionMatcher("@\\s*([^\\s]+)", 1), new Arglets.NameOptionMatcher("@\\s*([\"'])(.+?)\\1", 2)};

        @Override
        public int process(IParserHandler parserHandler, String argsLine) {
            Arglets.NameOptionMatcher[] nameOptionMatcherArray = optionMatchers;
            int n = optionMatchers.length;
            int n2 = 0;
            while (n2 < n) {
                Arglets.NameOptionMatcher oMatcher = nameOptionMatcherArray[n2];
                Matcher matcher = oMatcher.pattern.matcher(argsLine);
                if (matcher.lookingAt()) {
                    String fname = matcher.group(oMatcher.nameGroup);
                    int consumed = matcher.end();
                    if ("<<".equals(fname)) {
                        return consumed;
                    }
                    IPath path = Path.fromOSString((String)fname);
                    if (!path.isAbsolute()) {
                        fname = parserHandler.getCompilerWorkingDirectory().append(path).toOSString();
                    }
                    java.nio.file.Path fpath = Paths.get(fname, new String[0]);
                    try {
                        String args2 = new String(Files.readAllBytes(fpath));
                        parserHandler.parseArguments(args2);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    return consumed;
                }
                ++n2;
            }
            return 0;
        }
    }
}

